/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.scm;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ChangeSet.
 * 
 * @version $Revision$ $Date$
 */
public class ChangeSet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private String id;

    /**
     * Field author.
     */
    private String author;

    /**
     * Field comment.
     */
    private String comment;

    /**
     * Field date.
     */
    private long date = 0;

    /**
     * Field files.
     */
    private java.util.List files;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFile.
     * 
     * @param changeFile
     */
    public void addFile(ChangeFile changeFile)
    {
        if ( !(changeFile instanceof ChangeFile) )
        {
            throw new ClassCastException( "ChangeSet.addFiles(changeFile) parameter must be instanceof " + ChangeFile.class.getName() );
        }
        getFiles().add( changeFile );
    } //-- void addFile(ChangeFile) 

    /**
     * Get the author field.
     * 
     * @return String
     */
    public String getAuthor()
    {
        return this.author;
    } //-- String getAuthor() 

    /**
     * Get the comment field.
     * 
     * @return String
     */
    public String getComment()
    {
        return this.comment;
    } //-- String getComment() 

    /**
     * Get the date field.
     * 
     * @return long
     */
    public long getDate()
    {
        return this.date;
    } //-- long getDate() 

    /**
     * Method getFiles.
     * 
     * @return java.util.List
     */
    public java.util.List getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList();
        }
        
        return this.files;
    } //-- java.util.List getFiles() 

    /**
     * Get the id field.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method removeFile.
     * 
     * @param changeFile
     */
    public void removeFile(ChangeFile changeFile)
    {
        if ( !(changeFile instanceof ChangeFile) )
        {
            throw new ClassCastException( "ChangeSet.removeFiles(changeFile) parameter must be instanceof " + ChangeFile.class.getName() );
        }
        getFiles().remove( changeFile );
    } //-- void removeFile(ChangeFile) 

    /**
     * Set the author field.
     * 
     * @param author
     */
    public void setAuthor(String author)
    {
        this.author = author;
    } //-- void setAuthor(String) 

    /**
     * Set the comment field.
     * 
     * @param comment
     */
    public void setComment(String comment)
    {
        this.comment = comment;
    } //-- void setComment(String) 

    /**
     * Set the date field.
     * 
     * @param date
     */
    public void setDate(long date)
    {
        this.date = date;
    } //-- void setDate(long) 

    /**
     * Set the files field.
     * 
     * @param files
     */
    public void setFiles(java.util.List files)
    {
        this.files = files;
    } //-- void setFiles(java.util.List) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 


            /**
             * @return Returns string representation of the changeset
             */
            public String toString()
            {
                String result = author + "\n" + date + "\n";

                if ( files != null )
                {
                    for ( java.util.Iterator i = files.iterator(); i.hasNext(); )
                    {
                        ChangeFile file = (ChangeFile) i.next();

                        result += file + "\n";
                    }
                }

                result += comment;

                return result;
            }

            /**
             * @see java.lang.Object#equals(java.lang.Object)
             */
            public boolean equals( Object obj )
            {
                if ( obj instanceof ChangeSet )
                {
                    ChangeSet changeSet = (ChangeSet) obj;

                    if ( toString().equals( changeSet.toString() ) )
                    {
                        return true;
                    }
                }

                return false;
            }

            public java.util.Date getDateAsDate()
            {
                if ( date > 0 )
                {
                    return new java.util.Date( date );
                }

                return null;
            }
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
