/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.scm;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ScmResult.
 * 
 * @version $Revision$ $Date$
 */
public class ScmResult implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field success.
     */
    private boolean success = false;

    /**
     * Field commandLine.
     */
    private String commandLine;

    /**
     * Field providerMessage.
     */
    private String providerMessage;

    /**
     * Field commandOutput.
     */
    private String commandOutput;

    /**
     * Field exception.
     */
    private String exception;

    /**
     * Field changes.
     */
    private java.util.List changes;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addChange.
     * 
     * @param changeSet
     */
    public void addChange(ChangeSet changeSet)
    {
        if ( !(changeSet instanceof ChangeSet) )
        {
            throw new ClassCastException( "ScmResult.addChanges(changeSet) parameter must be instanceof " + ChangeSet.class.getName() );
        }
        getChanges().add( changeSet );
    } //-- void addChange(ChangeSet) 

    /**
     * Method getChanges.
     * 
     * @return java.util.List
     */
    public java.util.List getChanges()
    {
        if ( this.changes == null )
        {
            this.changes = new java.util.ArrayList();
        }
        
        return this.changes;
    } //-- java.util.List getChanges() 

    /**
     * Get the commandLine field.
     * 
     * @return String
     */
    public String getCommandLine()
    {
        return this.commandLine;
    } //-- String getCommandLine() 

    /**
     * Get the commandOutput field.
     * 
     * @return String
     */
    public String getCommandOutput()
    {
        return this.commandOutput;
    } //-- String getCommandOutput() 

    /**
     * Get the exception field.
     * 
     * @return String
     */
    public String getException()
    {
        return this.exception;
    } //-- String getException() 

    /**
     * Get the providerMessage field.
     * 
     * @return String
     */
    public String getProviderMessage()
    {
        return this.providerMessage;
    } //-- String getProviderMessage() 

    /**
     * Get the success field.
     * 
     * @return boolean
     */
    public boolean isSuccess()
    {
        return this.success;
    } //-- boolean isSuccess() 

    /**
     * Method removeChange.
     * 
     * @param changeSet
     */
    public void removeChange(ChangeSet changeSet)
    {
        if ( !(changeSet instanceof ChangeSet) )
        {
            throw new ClassCastException( "ScmResult.removeChanges(changeSet) parameter must be instanceof " + ChangeSet.class.getName() );
        }
        getChanges().remove( changeSet );
    } //-- void removeChange(ChangeSet) 

    /**
     * Set the changes field.
     * 
     * @param changes
     */
    public void setChanges(java.util.List changes)
    {
        this.changes = changes;
    } //-- void setChanges(java.util.List) 

    /**
     * Set the commandLine field.
     * 
     * @param commandLine
     */
    public void setCommandLine(String commandLine)
    {
        this.commandLine = commandLine;
    } //-- void setCommandLine(String) 

    /**
     * Set the commandOutput field.
     * 
     * @param commandOutput
     */
    public void setCommandOutput(String commandOutput)
    {
        this.commandOutput = commandOutput;
    } //-- void setCommandOutput(String) 

    /**
     * Set the exception field.
     * 
     * @param exception
     */
    public void setException(String exception)
    {
        this.exception = exception;
    } //-- void setException(String) 

    /**
     * Set the providerMessage field.
     * 
     * @param providerMessage
     */
    public void setProviderMessage(String providerMessage)
    {
        this.providerMessage = providerMessage;
    } //-- void setProviderMessage(String) 

    /**
     * Set the success field.
     * 
     * @param success
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    } //-- void setSuccess(boolean) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
