/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.system;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;

/**
 * Class Installation.
 * 
 * @version $Revision$ $Date$
 */
public class Installation implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field type.
     */
    private String type;

    /**
     * Field varValue.
     */
    private String varValue;

    /**
     * Field varName.
     */
    private String varName;

    /**
     * Field name.
     */
    private String name;

    /**
     * Field installationId.
     */
    private int installationId = 0;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Installation) )
        {
            return false;
        }
        
        Installation that = (Installation) other;
        boolean result = true;
        
        result = result && installationId == that.installationId;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the installationId field.
     * 
     * @return int
     */
    public int getInstallationId()
    {
        return this.installationId;
    } //-- int getInstallationId() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the type field.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get the varName field.
     * 
     * @return String
     */
    public String getVarName()
    {
        return this.varName;
    } //-- String getVarName() 

    /**
     * Get the varValue field.
     * 
     * @return String
     */
    public String getVarValue()
    {
        return this.varValue;
    } //-- String getVarValue() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) installationId;
        
        return result;
    } //-- int hashCode() 

    /**
     * Set the installationId field.
     * 
     * @param installationId
     */
    public void setInstallationId(int installationId)
    {
        this.installationId = installationId;
    } //-- void setInstallationId(int) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set the type field.
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set the varName field.
     * 
     * @param varName
     */
    public void setVarName(String varName)
    {
        this.varName = varName;
    } //-- void setVarName(String) 

    /**
     * Set the varValue field.
     * 
     * @param varValue
     */
    public void setVarValue(String varValue)
    {
        this.varValue = varValue;
    } //-- void setVarValue(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "installationId = '" );
        buf.append( getInstallationId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
