/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.system;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;

/**
 * Class Profile.
 * 
 * @version $Revision$ $Date$
 */
public class Profile implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field active.
     */
    private boolean active = false;

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * Field scmMode.
     */
    private int scmMode = 0;

    /**
     * Field buildWithoutChanges.
     */
    private boolean buildWithoutChanges = false;

    /**
     * Field jdk.
     */
    private Installation jdk;

    /**
     * Field builder.
     */
    private Installation builder;

    /**
     * Field environmentVariables.
     */
    private java.util.List environmentVariables;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addEnvironmentVariable.
     * 
     * @param installation
     */
    public void addEnvironmentVariable(Installation installation)
    {
        if ( !(installation instanceof Installation) )
        {
            throw new ClassCastException( "Profile.addEnvironmentVariables(installation) parameter must be instanceof " + Installation.class.getName() );
        }
        getEnvironmentVariables().add( installation );
    } //-- void addEnvironmentVariable(Installation) 

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Profile) )
        {
            return false;
        }
        
        Profile that = (Profile) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the builder field.
     * 
     * @return Installation
     */
    public Installation getBuilder()
    {
        return this.builder;
    } //-- Installation getBuilder() 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Method getEnvironmentVariables.
     * 
     * @return java.util.List
     */
    public java.util.List getEnvironmentVariables()
    {
        if ( this.environmentVariables == null )
        {
            this.environmentVariables = new java.util.ArrayList();
        }
        
        return this.environmentVariables;
    } //-- java.util.List getEnvironmentVariables() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the jdk field.
     * 
     * @return Installation
     */
    public Installation getJdk()
    {
        return this.jdk;
    } //-- Installation getJdk() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the scmMode field.
     * 
     * @return int
     */
    public int getScmMode()
    {
        return this.scmMode;
    } //-- int getScmMode() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the active field.
     * 
     * @return boolean
     */
    public boolean isActive()
    {
        return this.active;
    } //-- boolean isActive() 

    /**
     * Get the buildWithoutChanges field.
     * 
     * @return boolean
     */
    public boolean isBuildWithoutChanges()
    {
        return this.buildWithoutChanges;
    } //-- boolean isBuildWithoutChanges() 

    /**
     * Method removeEnvironmentVariable.
     * 
     * @param installation
     */
    public void removeEnvironmentVariable(Installation installation)
    {
        if ( !(installation instanceof Installation) )
        {
            throw new ClassCastException( "Profile.removeEnvironmentVariables(installation) parameter must be instanceof " + Installation.class.getName() );
        }
        getEnvironmentVariables().remove( installation );
    } //-- void removeEnvironmentVariable(Installation) 

    /**
     * Set the active field.
     * 
     * @param active
     */
    public void setActive(boolean active)
    {
        this.active = active;
    } //-- void setActive(boolean) 

    /**
     * Set the buildWithoutChanges field.
     * 
     * @param buildWithoutChanges
     */
    public void setBuildWithoutChanges(boolean buildWithoutChanges)
    {
        this.buildWithoutChanges = buildWithoutChanges;
    } //-- void setBuildWithoutChanges(boolean) 

    /**
     * Set the builder field.
     * 
     * @param builder
     */
    public void setBuilder(Installation builder)
    {
        this.builder = builder;
    } //-- void setBuilder(Installation) 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the environmentVariables field.
     * 
     * @param environmentVariables
     */
    public void setEnvironmentVariables(java.util.List environmentVariables)
    {
        this.environmentVariables = environmentVariables;
    } //-- void setEnvironmentVariables(java.util.List) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the jdk field.
     * 
     * @param jdk
     */
    public void setJdk(Installation jdk)
    {
        this.jdk = jdk;
    } //-- void setJdk(Installation) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set the scmMode field.
     * 
     * @param scmMode
     */
    public void setScmMode(int scmMode)
    {
        this.scmMode = scmMode;
    } //-- void setScmMode(int) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
