/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.system;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;

/**
 * Class SystemConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class SystemConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field guestAccountEnabled.
     */
    private boolean guestAccountEnabled = true;

    /**
     * Field defaultScheduleDescription.
     */
    private String defaultScheduleDescription = "Run hourly";

    /**
     * Field defaultScheduleCronExpression.
     */
    private String defaultScheduleCronExpression = "0 0 * * * ?";

    /**
     * Field workingDirectory.
     */
    private String workingDirectory = "working-directory";

    /**
     * Field buildOutputDirectory.
     */
    private String buildOutputDirectory = "build-output-directory";

    /**
     * Field deploymentRepositoryDirectory.
     */
    private String deploymentRepositoryDirectory;

    /**
     * Field baseUrl.
     */
    private String baseUrl;

    /**
     * Field initialized.
     */
    private boolean initialized = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the baseUrl field.
     * 
     * @return String
     */
    public String getBaseUrl()
    {
        return this.baseUrl;
    } //-- String getBaseUrl() 

    /**
     * Get the buildOutputDirectory field.
     * 
     * @return String
     */
    public String getBuildOutputDirectory()
    {
        return this.buildOutputDirectory;
    } //-- String getBuildOutputDirectory() 

    /**
     * Get the defaultScheduleCronExpression field.
     * 
     * @return String
     */
    public String getDefaultScheduleCronExpression()
    {
        return this.defaultScheduleCronExpression;
    } //-- String getDefaultScheduleCronExpression() 

    /**
     * Get the defaultScheduleDescription field.
     * 
     * @return String
     */
    public String getDefaultScheduleDescription()
    {
        return this.defaultScheduleDescription;
    } //-- String getDefaultScheduleDescription() 

    /**
     * Get the deploymentRepositoryDirectory field.
     * 
     * @return String
     */
    public String getDeploymentRepositoryDirectory()
    {
        return this.deploymentRepositoryDirectory;
    } //-- String getDeploymentRepositoryDirectory() 

    /**
     * Get the workingDirectory field.
     * 
     * @return String
     */
    public String getWorkingDirectory()
    {
        return this.workingDirectory;
    } //-- String getWorkingDirectory() 

    /**
     * Get the guestAccountEnabled field.
     * 
     * @return boolean
     */
    public boolean isGuestAccountEnabled()
    {
        return this.guestAccountEnabled;
    } //-- boolean isGuestAccountEnabled() 

    /**
     * Get the initialized field.
     * 
     * @return boolean
     */
    public boolean isInitialized()
    {
        return this.initialized;
    } //-- boolean isInitialized() 

    /**
     * Set the baseUrl field.
     * 
     * @param baseUrl
     */
    public void setBaseUrl(String baseUrl)
    {
        this.baseUrl = baseUrl;
    } //-- void setBaseUrl(String) 

    /**
     * Set the buildOutputDirectory field.
     * 
     * @param buildOutputDirectory
     */
    public void setBuildOutputDirectory(String buildOutputDirectory)
    {
        this.buildOutputDirectory = buildOutputDirectory;
    } //-- void setBuildOutputDirectory(String) 

    /**
     * Set the defaultScheduleCronExpression field.
     * 
     * @param defaultScheduleCronExpression
     */
    public void setDefaultScheduleCronExpression(String defaultScheduleCronExpression)
    {
        this.defaultScheduleCronExpression = defaultScheduleCronExpression;
    } //-- void setDefaultScheduleCronExpression(String) 

    /**
     * Set the defaultScheduleDescription field.
     * 
     * @param defaultScheduleDescription
     */
    public void setDefaultScheduleDescription(String defaultScheduleDescription)
    {
        this.defaultScheduleDescription = defaultScheduleDescription;
    } //-- void setDefaultScheduleDescription(String) 

    /**
     * Set the deploymentRepositoryDirectory field.
     * 
     * @param deploymentRepositoryDirectory
     */
    public void setDeploymentRepositoryDirectory(String deploymentRepositoryDirectory)
    {
        this.deploymentRepositoryDirectory = deploymentRepositoryDirectory;
    } //-- void setDeploymentRepositoryDirectory(String) 

    /**
     * Set the guestAccountEnabled field.
     * 
     * @param guestAccountEnabled
     */
    public void setGuestAccountEnabled(boolean guestAccountEnabled)
    {
        this.guestAccountEnabled = guestAccountEnabled;
    } //-- void setGuestAccountEnabled(boolean) 

    /**
     * Set the initialized field.
     * 
     * @param initialized
     */
    public void setInitialized(boolean initialized)
    {
        this.initialized = initialized;
    } //-- void setInitialized(boolean) 

    /**
     * Set the workingDirectory field.
     * 
     * @param workingDirectory
     */
    public void setWorkingDirectory(String workingDirectory)
    {
        this.workingDirectory = workingDirectory;
    } //-- void setWorkingDirectory(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
