/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.scm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet
implements Serializable {
    private String id;
    private String author;
    private String comment;
    private long date = 0L;
    private List<ChangeFile> files;

    public void addFile(ChangeFile changeFile) {
        this.getFiles().add(changeFile);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public long getDate() {
        return this.date;
    }

    public List<ChangeFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<ChangeFile>();
        }
        return this.files;
    }

    public String getId() {
        return this.id;
    }

    public void removeFile(ChangeFile changeFile) {
        this.getFiles().remove(changeFile);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public void setFiles(List<ChangeFile> files) {
        this.files = files;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        String result = this.author + "\n" + this.date + "\n";
        if (this.files != null) {
            for (ChangeFile file : this.files) {
                result = result + file + "\n";
            }
        }
        result = result + this.comment;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeSet) {
            ChangeSet changeSet = (ChangeSet)obj;
            if (this.toString().equals(changeSet.toString())) {
                return true;
            }
        }
        return false;
    }

    public Date getDateAsDate() {
        if (this.date > 0L) {
            return new Date(this.date);
        }
        return null;
    }
}

