/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.system;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.continuum.xmlrpc.system.Installation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
implements Serializable {
    private int id = 0;
    private boolean active = false;
    private String name;
    private String description;
    private int scmMode = 0;
    private boolean buildWithoutChanges = false;
    private Installation jdk;
    private Installation builder;
    private List<Installation> environmentVariables;

    public void addEnvironmentVariable(Installation installation) {
        this.getEnvironmentVariables().add(installation);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Profile)) {
            return false;
        }
        Profile that = (Profile)other;
        boolean result = true;
        result = result && this.id == that.id;
        return result;
    }

    public Installation getBuilder() {
        return this.builder;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Installation> getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = new ArrayList<Installation>();
        }
        return this.environmentVariables;
    }

    public int getId() {
        return this.id;
    }

    public Installation getJdk() {
        return this.jdk;
    }

    public String getName() {
        return this.name;
    }

    public int getScmMode() {
        return this.scmMode;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.id;
        return result;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isBuildWithoutChanges() {
        return this.buildWithoutChanges;
    }

    public void removeEnvironmentVariable(Installation installation) {
        this.getEnvironmentVariables().remove(installation);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setBuildWithoutChanges(boolean buildWithoutChanges) {
        this.buildWithoutChanges = buildWithoutChanges;
    }

    public void setBuilder(Installation builder) {
        this.builder = builder;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnvironmentVariables(List<Installation> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setJdk(Installation jdk) {
        this.jdk = jdk;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScmMode(int scmMode) {
        this.scmMode = scmMode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("id = '");
        buf.append(this.getId());
        buf.append("'");
        return buf.toString();
    }
}

