/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.fuzz;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import org.apache.comet.fuzz.Function;
import org.apache.comet.fuzz.Meta$;
import org.apache.comet.fuzz.Utils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class QueryGen$ {
    public static QueryGen$ MODULE$;

    static {
        new QueryGen$();
    }

    public void generateRandomQueries(Random r, SparkSession spark, int numFiles, int numQueries) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFiles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> spark.read().parquet(new StringBuilder(12).append("test").append(i).append(".parquet").toString()).createTempView(new StringBuilder(4).append("test").append(i).toString()));
        BufferedWriter w = new BufferedWriter(new FileWriter("queries.sql"));
        HashSet uniqueQueries = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numQueries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            block9: {
                String string;
                int n = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(r.nextInt())) % 8;
                switch (n) {
                    case 0: {
                        string = MODULE$.generateJoin(r, spark, numFiles);
                        break;
                    }
                    case 1: {
                        string = MODULE$.generateAggregate(r, spark, numFiles);
                        break;
                    }
                    case 2: {
                        string = MODULE$.generateScalar(r, spark, numFiles);
                        break;
                    }
                    case 3: {
                        string = MODULE$.generateCast(r, spark, numFiles);
                        break;
                    }
                    case 4: {
                        string = MODULE$.generateUnaryArithmetic(r, spark, numFiles);
                        break;
                    }
                    case 5: {
                        string = MODULE$.generateBinaryArithmetic(r, spark, numFiles);
                        break;
                    }
                    case 6: {
                        string = MODULE$.generateBinaryComparison(r, spark, numFiles);
                        break;
                    }
                    default: {
                        string = MODULE$.generateConditional(r, spark, numFiles);
                        break;
                    }
                }
                String sql = string;
                if (uniqueQueries.contains((Object)sql)) break block9;
                uniqueQueries.$plus$eq((Object)sql);
                w.write(new StringBuilder(1).append(sql).append("\n").toString());
            }
        });
        w.close();
    }

    private String generateAggregate(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        Function func = Utils$.MODULE$.randomChoice(Meta$.MODULE$.aggFunc(), r);
        IndexedSeq args = (IndexedSeq)package$.MODULE$.Range().apply(0, func.num_args()).map((Function1 & Serializable & scala.Serializable)x$1 -> QueryGen$.$anonfun$generateAggregate$1(table, r, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq groupingCols = (IndexedSeq)package$.MODULE$.Range().apply(0, 2).map((Function1 & Serializable & scala.Serializable)x$2 -> QueryGen$.$anonfun$generateAggregate$2(table, r, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        return groupingCols.isEmpty() ? new StringBuilder(33).append("SELECT ").append(args.mkString(", ")).append(", ").append(func.name()).append("(").append(args.mkString(", ")).append(") AS x ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(args.mkString(", ")).append(";").toString() : new StringBuilder(38).append("SELECT ").append(groupingCols.mkString(", ")).append(", ").append(func.name()).append("(").append(args.mkString(", ")).append(") ").append("FROM ").append(tableName).append(" ").append("GROUP BY ").append(groupingCols.mkString(",")).append(" ").append("ORDER BY ").append(groupingCols.mkString(", ")).append(";").toString();
    }

    private String generateScalar(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        Function func = Utils$.MODULE$.randomChoice(Meta$.MODULE$.scalarFunc(), r);
        IndexedSeq args = (IndexedSeq)package$.MODULE$.Range().apply(0, func.num_args()).map((Function1 & Serializable & scala.Serializable)x$3 -> QueryGen$.$anonfun$generateScalar$1(table, r, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        return new StringBuilder(33).append("SELECT ").append(args.mkString(", ")).append(", ").append(func.name()).append("(").append(args.mkString(", ")).append(") AS x ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(args.mkString(", ")).append(";").toString();
    }

    private String generateUnaryArithmetic(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        String op = Utils$.MODULE$.randomChoice(Meta$.MODULE$.unaryArithmeticOps(), r);
        String a = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        return new StringBuilder(26).append("SELECT ").append(a).append(", ").append(op).append(a).append(" ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(a).append(";").toString();
    }

    private String generateBinaryArithmetic(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        String op = Utils$.MODULE$.randomChoice(Meta$.MODULE$.binaryArithmeticOps(), r);
        String a = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        String b = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        return new StringBuilder(32).append("SELECT ").append(a).append(", ").append(b).append(", ").append(a).append(" ").append(op).append(" ").append(b).append(" ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(a).append(", ").append(b).append(";").toString();
    }

    private String generateBinaryComparison(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        String op = Utils$.MODULE$.randomChoice(Meta$.MODULE$.comparisonOps(), r);
        String a = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        String b = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        return new StringBuilder(32).append("SELECT ").append(a).append(", ").append(b).append(", ").append(a).append(" ").append(op).append(" ").append(b).append(" ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(a).append(", ").append(b).append(";").toString();
    }

    private String generateConditional(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        String op = Utils$.MODULE$.randomChoice(Meta$.MODULE$.comparisonOps(), r);
        String a = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        String b = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        return new StringBuilder(78).append("SELECT ").append(a).append(", ").append(b).append(", ").append(a).append(" ").append(op).append(" ").append(b).append(", IF(").append(a).append(" ").append(op).append(" ").append(b).append(", 1, 2), CASE WHEN ").append(a).append(" ").append(op).append(" ").append(b).append(" THEN 1 ELSE 2 END ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(a).append(", ").append(b).append(";").toString();
    }

    private String generateCast(Random r, SparkSession spark, int numFiles) {
        String tableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset table = spark.table(tableName);
        String toType = Utils$.MODULE$.randomWeightedChoice(Meta$.MODULE$.dataTypes(), r).sql();
        String arg = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table.columns()), r);
        return new StringBuilder(52).append("SELECT ").append(arg).append(", cast(").append(arg).append(" as ").append(toType).append("), try_cast(").append(arg).append(" as ").append(toType).append(") ").append("FROM ").append(tableName).append(" ").append("ORDER BY ").append(arg).append(";").toString();
    }

    private String generateJoin(Random r, SparkSession spark, int numFiles) {
        String leftTableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        String rightTableName = new StringBuilder(4).append("test").append(r.nextInt(numFiles)).toString();
        Dataset leftTable = spark.table(leftTableName);
        Dataset rightTable = spark.table(rightTableName);
        String leftCol = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])leftTable.columns()), r);
        String rightCol = (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])rightTable.columns()), r);
        Seq joinTypes = (Seq)new .colon.colon((Object)new Tuple2((Object)"INNER", (Object)BoxesRunTime.boxToDouble((double)0.4)), (List)new .colon.colon((Object)new Tuple2((Object)"LEFT", (Object)BoxesRunTime.boxToDouble((double)0.3)), (List)new .colon.colon((Object)new Tuple2((Object)"RIGHT", (Object)BoxesRunTime.boxToDouble((double)0.3)), (List)Nil$.MODULE$)));
        String joinType = (String)Utils$.MODULE$.randomWeightedChoice(joinTypes, r);
        String leftColProjection = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftTable.columns())).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("l.").append((String)c).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String rightColProjection = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightTable.columns())).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("r.").append((String)c).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        return new StringBuilder(50).append("SELECT ").append(leftColProjection).append(", ").append(rightColProjection).append(" ").append("FROM ").append(leftTableName).append(" l ").append(joinType).append(" JOIN ").append(rightTableName).append(" r ").append("ON l.").append(leftCol).append(" = r.").append(rightCol).append(" ").append("ORDER BY ").append(leftColProjection).append(", ").append(rightColProjection).append(";").toString();
    }

    public static final /* synthetic */ String $anonfun$generateAggregate$1(Dataset table$1, Random r$2, int x$1) {
        return (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table$1.columns()), r$2);
    }

    public static final /* synthetic */ String $anonfun$generateAggregate$2(Dataset table$1, Random r$2, int x$2) {
        return (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table$1.columns()), r$2);
    }

    public static final /* synthetic */ String $anonfun$generateScalar$1(Dataset table$2, Random r$3, int x$3) {
        return (String)Utils$.MODULE$.randomChoice(Predef$.MODULE$.wrapRefArray((Object[])table$2.columns()), r$3);
    }

    private QueryGen$() {
        MODULE$ = this;
    }
}

