/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.fuzz;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class QueryRunner$ {
    public static QueryRunner$ MODULE$;

    static {
        new QueryRunner$();
    }

    public void runQueries(SparkSession spark, int numFiles, String filename, boolean showMatchingResults, boolean showFailedSparkQueries) {
        String outputFilename = new StringBuilder(11).append("results-").append(System.currentTimeMillis()).append(".md").toString();
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Writing results to ").append(outputFilename).toString());
        BufferedWriter w = new BufferedWriter(new FileWriter(outputFilename));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFiles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Dataset table = spark.read().parquet(new StringBuilder(12).append("test").append(i).append(".parquet").toString());
            String tableName = new StringBuilder(4).append("test").append(i).toString();
            table.createTempView(tableName);
            w.write(new StringBuilder(31).append("Created table ").append(tableName).append(" with schema:\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(2).append(f.name()).append(": ").append(f.dataType()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n\t")).append("\n\n").toString());
        });
        BufferedSource querySource = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        try {
            querySource.getLines().foreach((Function1 & Serializable & scala.Serializable)sql -> {
                QueryRunner$.$anonfun$runQueries$3(spark, w, showFailedSparkQueries, sql);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            w.close();
            querySource.close();
        }
    }

    public boolean runQueries$default$5() {
        return false;
    }

    private String formatRow(Row row) {
        return ((TraversableOnce)row.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object == null) {
                string = "NULL";
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byArray)).mkString();
            } else {
                string = object.toString();
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private void showSQL(BufferedWriter w, String sql, int maxLength) {
        w.write("## SQL\n");
        w.write("```\n");
        String[] words = sql.split(" ");
        scala.collection.mutable.StringBuilder currentLine = new scala.collection.mutable.StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).foreach((Function1 & Serializable & scala.Serializable)word -> {
            block0: {
                if (currentLine.length() + word.length() + 1 <= maxLength) break block0;
                w.write(currentLine.toString().trim());
                w.write("\n");
                currentLine.setLength(0);
            }
            return currentLine.append(word).append(" ");
        });
        if (currentLine.nonEmpty()) {
            w.write(currentLine.toString().trim());
            w.write("\n");
        }
        w.write("```\n");
    }

    private int showSQL$default$3() {
        return 120;
    }

    private void showPlans(BufferedWriter w, String sparkPlan, String cometPlan) {
        w.write("### Spark Plan\n");
        w.write(new StringBuilder(9).append("```\n").append(sparkPlan).append("\n```\n").toString());
        w.write("### Comet Plan\n");
        w.write(new StringBuilder(9).append("```\n").append(cometPlan).append("\n```\n").toString());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$runQueries$4(Row l$1, Row r$1, BufferedWriter w$1, String sql$1, String sparkPlan$1, String cometPlan$1, IntRef i$1, Row[] sparkRows$1, int j) {
        block11: {
            block5: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        var11_9 = new Tuple2(l$1.apply(j), r$1.apply(j));
                                        if (var11_9 == null) break block4;
                                        a = var11_9._1();
                                        b = var11_9._2();
                                        if (!(a instanceof Float)) break block4;
                                        var14_12 = BoxesRunTime.unboxToFloat((Object)a);
                                        if (!(b instanceof Float)) break block4;
                                        var15_13 = BoxesRunTime.unboxToFloat((Object)b);
                                        if (!RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(var14_12))) break block4;
                                        var9_14 = RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(var15_13));
                                        break block5;
                                    }
                                    if (var11_9 == null) break block6;
                                    a = var11_9._1();
                                    b = var11_9._2();
                                    if (!(a instanceof Float)) break block6;
                                    var18_17 = BoxesRunTime.unboxToFloat((Object)a);
                                    if (!(b instanceof Float)) break block6;
                                    var19_18 = BoxesRunTime.unboxToFloat((Object)b);
                                    if (!Float.isNaN(var18_17)) break block6;
                                    var9_14 = Float.isNaN(var19_18);
                                    break block5;
                                }
                                if (var11_9 == null) break block7;
                                a = var11_9._1();
                                b = var11_9._2();
                                if (!(a instanceof Float)) break block7;
                                var22_21 = BoxesRunTime.unboxToFloat((Object)a);
                                if (!(b instanceof Float)) break block7;
                                var23_22 = BoxesRunTime.unboxToFloat((Object)b);
                                var9_14 = RichFloat$.MODULE$.abs$extension(Predef$.MODULE$.floatWrapper(var22_21 - var23_22)) <= 1.0E-6f;
                                break block5;
                            }
                            if (var11_9 == null) break block8;
                            a = var11_9._1();
                            b = var11_9._2();
                            if (!(a instanceof Double)) break block8;
                            var26_25 = BoxesRunTime.unboxToDouble((Object)a);
                            if (!(b instanceof Double)) break block8;
                            var28_26 = BoxesRunTime.unboxToDouble((Object)b);
                            if (!RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(var26_25))) break block8;
                            var9_14 = RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(var28_26));
                            break block5;
                        }
                        if (var11_9 == null) break block9;
                        a = var11_9._1();
                        b = var11_9._2();
                        if (!(a instanceof Double)) break block9;
                        var32_29 = BoxesRunTime.unboxToDouble((Object)a);
                        if (!(b instanceof Double)) break block9;
                        var34_30 = BoxesRunTime.unboxToDouble((Object)b);
                        if (!Double.isNaN(var32_29)) break block9;
                        var9_14 = Double.isNaN(var34_30);
                        break block5;
                    }
                    if (var11_9 == null) break block10;
                    a = var11_9._1();
                    b = var11_9._2();
                    if (!(a instanceof Double)) break block10;
                    var38_33 = BoxesRunTime.unboxToDouble((Object)a);
                    if (!(b instanceof Double)) break block10;
                    var40_34 = BoxesRunTime.unboxToDouble((Object)b);
                    var9_14 = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(var38_33 - var40_34)) <= 1.0E-6;
                    break block5;
                }
                if (var11_9 == null) ** GOTO lbl-1000
                a = var11_9._1();
                b = var11_9._2();
                if (!(a instanceof byte[])) ** GOTO lbl-1000
                var44_37 = (byte[])a;
                if (b instanceof byte[]) {
                    var45_38 = (byte[])b;
                    var9_14 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(var44_37)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(var45_38));
                } else if (var11_9 != null) {
                    a = var11_9._1();
                    var9_14 = BoxesRunTime.equals((Object)a, (Object)(b = var11_9._2())) != false;
                } else {
                    throw new MatchError((Object)var11_9);
                }
            }
            same = var9_14;
            if (same) break block11;
            QueryRunner$.MODULE$.showSQL(w$1, sql$1, QueryRunner$.MODULE$.showSQL$default$3());
            QueryRunner$.MODULE$.showPlans(w$1, sparkPlan$1, cometPlan$1);
            w$1.write(new StringBuilder(26).append("First difference at row ").append(i$1.elem).append(":\n").toString());
            w$1.write(new StringBuilder(10).append("Spark: `").append(QueryRunner$.MODULE$.formatRow(l$1)).append("`\n").toString());
            w$1.write(new StringBuilder(10).append("Comet: `").append(QueryRunner$.MODULE$.formatRow(r$1)).append("`\n").toString());
            i$1.elem = sparkRows$1.length;
        }
    }

    public static final /* synthetic */ void $anonfun$runQueries$3(SparkSession spark$1, BufferedWriter w$1, boolean showFailedSparkQueries$1, String sql) {
        block7: {
            try {
                spark$1.conf().set("spark.comet.enabled", "false");
                Dataset df = spark$1.sql(sql);
                Row[] sparkRows = (Row[])df.collect();
                String sparkPlan = df.queryExecution().executedPlan().toString();
                try {
                    spark$1.conf().set("spark.comet.enabled", "true");
                    Dataset df2 = spark$1.sql(sql);
                    Row[] cometRows = (Row[])df2.collect();
                    String cometPlan = df2.queryExecution().executedPlan().toString();
                    if (sparkRows.length == cometRows.length) {
                        IntRef i = IntRef.create((int)0);
                        while (i.elem < sparkRows.length) {
                            Row l = sparkRows[i.elem];
                            Row r = cometRows[i.elem];
                            Predef$.MODULE$.assert(l.length() == r.length());
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), l.length()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> QueryRunner$.$anonfun$runQueries$4(l, r, w$1, sql, sparkPlan, cometPlan, i, sparkRows, arg_0)));
                            ++i.elem;
                        }
                    } else {
                        MODULE$.showSQL(w$1, sql, MODULE$.showSQL$default$3());
                        MODULE$.showPlans(w$1, sparkPlan, cometPlan);
                        w$1.write(new StringBuilder(55).append("[ERROR] Spark produced ").append(sparkRows.length).append(" rows and ").append("Comet produced ").append(cometRows.length).append(" rows.\n").toString());
                    }
                }
                catch (Exception e) {
                    MODULE$.showSQL(w$1, sql, MODULE$.showSQL$default$3());
                    w$1.write(new StringBuilder(33).append("[ERROR] Query failed in Comet: ").append(e.getMessage()).append(":\n").toString());
                    w$1.write("```\n");
                    StringWriter sw = new StringWriter();
                    PrintWriter p = new PrintWriter(sw);
                    e.printStackTrace(p);
                    p.close();
                    w$1.write(new StringBuilder(1).append(sw.toString()).append("\n").toString());
                    w$1.write("```\n");
                }
                w$1.flush();
            }
            catch (Exception e) {
                if (!showFailedSparkQueries$1) break block7;
                MODULE$.showSQL(w$1, sql, MODULE$.showSQL$default$3());
                w$1.write(new StringBuilder(24).append("Query failed in Spark: ").append(e.getMessage()).append("\n").toString());
            }
        }
    }

    private QueryRunner$() {
        MODULE$ = this;
    }
}

