/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.comet.parquet.CometInputFile;
import org.apache.comet.parquet.FileReader;
import org.apache.comet.parquet.ReadOptions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.spark.sql.execution.datasources.PartitionedFile;

public class FooterReader {
    public static ParquetMetadata readFooter(Configuration configuration, PartitionedFile file) throws IOException, URISyntaxException {
        long start = file.start();
        long length = file.length();
        Path filePath = new Path(new URI(file.filePath().toString()));
        CometInputFile inputFile = CometInputFile.fromPath(filePath, configuration);
        ParquetReadOptions readOptions = HadoopReadOptions.builder((Configuration)inputFile.getConf(), (Path)inputFile.getPath()).withRange(start, start + length).build();
        ReadOptions cometReadOptions = ReadOptions.builder(configuration).build();
        try (FileReader fileReader = new FileReader(inputFile, readOptions, cometReadOptions);){
            ParquetMetadata parquetMetadata = fileReader.getFooter();
            return parquetMetadata;
        }
    }
}

