/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import org.apache.comet.parquet.ColumnPageReader;
import org.apache.comet.parquet.ColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.shaded.arrow.c.CometSchemaImporter;
import org.apache.comet.vector.CometLazyVector;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReader;
import org.apache.spark.sql.types.DataType;

public class LazyColumnReader
extends ColumnReader {
    private int lastSkippedRowId = Integer.MAX_VALUE;
    private boolean isPageDrained = true;
    private int numRowsToSkipFromPrevBatch;
    private final CometLazyVector vector;

    public LazyColumnReader(DataType sparkReadType, ColumnDescriptor descriptor, CometSchemaImporter importer, int batchSize, boolean useDecimal128, boolean useLegacyDateTimestamp) {
        super(sparkReadType, descriptor, importer, batchSize, useDecimal128, useLegacyDateTimestamp);
        this.batchSize = 0;
        this.vector = new CometLazyVector(sparkReadType, this, useDecimal128);
    }

    @Override
    public void setPageReader(PageReader pageReader) throws IOException {
        super.setPageReader(pageReader);
        this.lastSkippedRowId = Integer.MAX_VALUE;
        this.isPageDrained = true;
        this.numRowsToSkipFromPrevBatch = 0;
        this.currentNumValues = this.batchSize;
    }

    @Override
    public void readBatch(int total) {
        this.tryPageSkip(this.batchSize);
        this.numRowsToSkipFromPrevBatch += this.batchSize - this.currentNumValues;
        Native.resetBatch(this.nativeHandle);
        this.batchSize = total;
        this.currentNumValues = 0;
        this.lastSkippedRowId = -1;
    }

    @Override
    public CometVector currentBatch() {
        return this.vector;
    }

    public void readAllBatch() {
        assert (this.lastSkippedRowId == -1);
        this.readBatch(this.batchSize - 1, 0);
    }

    public boolean materializeUpToIfNecessary(int rowId) {
        assert (rowId > this.lastSkippedRowId);
        if (rowId < this.currentNumValues) {
            return false;
        }
        int numRowsWholePageSkipped = this.tryPageSkip(rowId);
        this.readBatch(rowId, numRowsWholePageSkipped);
        return true;
    }

    private void readBatch(int rowId, int numNullRowsToPad) {
        if (this.numRowsToSkipFromPrevBatch > 0) {
            this.readPage();
            this.isPageDrained = false;
            Native.skipBatch(this.nativeHandle, this.numRowsToSkipFromPrevBatch, true);
            this.numRowsToSkipFromPrevBatch = 0;
        }
        while (rowId >= this.currentNumValues) {
            int[] array;
            int read;
            int numRowsToRead = this.batchSize - this.currentNumValues;
            if (this.isPageDrained) {
                this.readPage();
            }
            this.isPageDrained = (read = (array = Native.readBatch(this.nativeHandle, numRowsToRead, numNullRowsToPad))[0]) < numRowsToRead;
            this.currentNumValues += read;
            this.currentNumNulls += array[1];
        }
    }

    private int tryPageSkip(int rowId) {
        int total = rowId - this.currentNumValues;
        int wholePageSkipped = 0;
        if (total > 0) {
            int skipped = this.isPageDrained ? 0 : Native.skipBatch(this.nativeHandle, total);
            boolean bl = this.isPageDrained = (total -= skipped) > 0;
            if (this.isPageDrained) {
                ColumnPageReader columnPageReader = (ColumnPageReader)this.pageReader;
                int pageValueCount = columnPageReader.getPageValueCount() - this.numRowsToSkipFromPrevBatch;
                while (pageValueCount <= total) {
                    columnPageReader.skipPage();
                    this.numRowsToSkipFromPrevBatch = 0;
                    total -= pageValueCount;
                    wholePageSkipped += pageValueCount;
                    pageValueCount = columnPageReader.getPageValueCount();
                }
            }
            this.currentNumValues += skipped + wholePageSkipped;
            this.currentNumNulls += skipped;
            this.lastSkippedRowId = this.currentNumValues - 1;
        }
        return wholePageSkipped;
    }
}

