/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.parquet.ColumnReader;
import org.apache.comet.parquet.LazyColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.parquet.TypeUtil;
import org.apache.comet.shaded.arrow.c.CometSchemaImporter;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;

public class Utils {
    public static ColumnReader getColumnReader(DataType type, ColumnDescriptor descriptor, CometSchemaImporter importer, int batchSize, boolean useDecimal128, boolean useLazyMaterialization) {
        return Utils.getColumnReader(type, descriptor, importer, batchSize, useDecimal128, useLazyMaterialization, true);
    }

    public static ColumnReader getColumnReader(DataType type, ColumnDescriptor descriptor, CometSchemaImporter importer, int batchSize, boolean useDecimal128, boolean useLazyMaterialization, boolean useLegacyDateTimestamp) {
        if (useLazyMaterialization && Utils.supportLazyMaterialization(type)) {
            return new LazyColumnReader(type, descriptor, importer, batchSize, useDecimal128, useLegacyDateTimestamp);
        }
        return new ColumnReader(type, descriptor, importer, batchSize, useDecimal128, useLegacyDateTimestamp);
    }

    private static boolean supportLazyMaterialization(DataType type) {
        return type instanceof StringType || type instanceof BinaryType;
    }

    public static long initColumnReader(ColumnDescriptor descriptor, DataType readType, int batchSize, boolean useDecimal128, boolean useLegacyDateTimestampOrNTZ) {
        PrimitiveType primitiveType = descriptor.getPrimitiveType();
        int primitiveTypeId = Utils.getPhysicalTypeId(primitiveType.getPrimitiveTypeName());
        LogicalTypeAnnotation annotation = primitiveType.getLogicalTypeAnnotation();
        int bitWidth = -1;
        boolean isSigned = false;
        if (annotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)annotation;
            bitWidth = intAnnotation.getBitWidth();
            isSigned = intAnnotation.isSigned();
        }
        int scale = -1;
        int precision = -1;
        if (annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation;
            precision = decimalAnnotation.getPrecision();
            scale = decimalAnnotation.getScale();
        }
        int tu = -1;
        boolean isAdjustedUtc = false;
        if (annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
            tu = Utils.getTimeUnitId(timestampAnnotation.getUnit());
            isAdjustedUtc = timestampAnnotation.isAdjustedToUTC();
        }
        TypePromotionInfo promotionInfo = readType != null ? new TypePromotionInfo(readType) : new TypePromotionInfo(primitiveTypeId, precision, scale, bitWidth);
        return Native.initColumnReader(primitiveTypeId, Utils.getLogicalTypeId(annotation), promotionInfo.physicalTypeId, descriptor.getPath(), descriptor.getMaxDefinitionLevel(), descriptor.getMaxRepetitionLevel(), bitWidth, promotionInfo.bitWidth, isSigned, primitiveType.getTypeLength(), precision, promotionInfo.precision, scale, promotionInfo.scale, tu, isAdjustedUtc, batchSize, useDecimal128, useLegacyDateTimestampOrNTZ);
    }

    static int getPhysicalTypeId(PrimitiveType.PrimitiveTypeName typeName) {
        switch (typeName) {
            case BOOLEAN: {
                return 0;
            }
            case INT32: {
                return 1;
            }
            case INT64: {
                return 2;
            }
            case INT96: {
                return 3;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 5;
            }
            case BINARY: {
                return 6;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Invalid Parquet physical type: " + typeName);
    }

    static int getLogicalTypeId(LogicalTypeAnnotation annotation) {
        if (annotation == null) {
            return -1;
        }
        if (annotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            return 0;
        }
        if (annotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
            return 1;
        }
        if (annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            return 2;
        }
        if (annotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            return 3;
        }
        if (annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            return 4;
        }
        if (annotation instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation) {
            return 5;
        }
        if (annotation instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
            return 6;
        }
        throw new UnsupportedOperationException("Unsupported Parquet logical type " + annotation);
    }

    static int getTimeUnitId(LogicalTypeAnnotation.TimeUnit tu) {
        switch (tu) {
            case MILLIS: {
                return 0;
            }
            case MICROS: {
                return 1;
            }
            case NANOS: {
                return 2;
            }
        }
        throw new UnsupportedOperationException("Unsupported TimeUnit " + tu);
    }

    static class TypePromotionInfo {
        int physicalTypeId;
        int precision;
        int scale;
        int bitWidth;

        TypePromotionInfo(int physicalTypeId, int precision, int scale, int bitWidth) {
            this.physicalTypeId = physicalTypeId;
            this.precision = precision;
            this.scale = scale;
            this.bitWidth = bitWidth;
        }

        TypePromotionInfo(DataType sparkReadType) {
            StructField f = new StructField("f", sparkReadType, false, Metadata.empty());
            ColumnDescriptor descriptor = TypeUtil.convertToParquet(f);
            PrimitiveType primitiveType = descriptor.getPrimitiveType();
            int physicalTypeId = Utils.getPhysicalTypeId(primitiveType.getPrimitiveTypeName());
            LogicalTypeAnnotation annotation = primitiveType.getLogicalTypeAnnotation();
            int precision = -1;
            int scale = -1;
            int bitWidth = -1;
            if (annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation;
                precision = decimalAnnotation.getPrecision();
                scale = decimalAnnotation.getScale();
            }
            if (annotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                LogicalTypeAnnotation.IntLogicalTypeAnnotation intAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)annotation;
                bitWidth = intAnnotation.getBitWidth();
            }
            this.physicalTypeId = physicalTypeId;
            this.precision = precision;
            this.scale = scale;
            this.bitWidth = bitWidth;
        }
    }
}

