/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.memory.unsafe;

import org.apache.comet.shaded.arrow.memory.AllocationManager;
import org.apache.comet.shaded.arrow.memory.ArrowBuf;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.memory.ReferenceManager;
import org.apache.comet.shaded.arrow.memory.util.MemoryUtil;

public final class UnsafeAllocationManager
extends AllocationManager {
    private static final ArrowBuf EMPTY = new ArrowBuf(ReferenceManager.NO_OP, null, 0L, MemoryUtil.UNSAFE.allocateMemory(0L));
    public static final AllocationManager.Factory FACTORY = new AllocationManager.Factory(){

        @Override
        public AllocationManager create(BufferAllocator accountingAllocator, long size) {
            return new UnsafeAllocationManager(accountingAllocator, size);
        }

        @Override
        public ArrowBuf empty() {
            return EMPTY;
        }
    };
    private final long allocatedSize;
    private final long allocatedAddress;

    UnsafeAllocationManager(BufferAllocator accountingAllocator, long requestedSize) {
        super(accountingAllocator);
        this.allocatedAddress = MemoryUtil.UNSAFE.allocateMemory(requestedSize);
        this.allocatedSize = requestedSize;
    }

    @Override
    public long getSize() {
        return this.allocatedSize;
    }

    @Override
    protected long memoryAddress() {
        return this.allocatedAddress;
    }

    @Override
    protected void release0() {
        MemoryUtil.UNSAFE.freeMemory(this.allocatedAddress);
    }
}

