/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.vector.CometPlainVector;
import org.apache.spark.unsafe.types.UTF8String;

public class CometDictionary
implements AutoCloseable {
    private static final int DECIMAL_BYTE_WIDTH = 16;
    private CometPlainVector values;
    private final int numValues;
    private volatile ByteArrayWrapper[] binaries;

    public CometDictionary(CometPlainVector values) {
        this.values = values;
        this.numValues = values.numValues();
    }

    public void setDictionaryVector(CometPlainVector values) {
        this.values = values;
        if (values.numValues() != this.numValues) {
            throw new IllegalArgumentException("Mismatched dictionary size");
        }
    }

    public ValueVector getValueVector() {
        return this.values.getValueVector();
    }

    public boolean decodeToBoolean(int index) {
        return this.values.getBoolean(index);
    }

    public byte decodeToByte(int index) {
        return this.values.getByte(index);
    }

    public short decodeToShort(int index) {
        return this.values.getShort(index);
    }

    public int decodeToInt(int index) {
        return this.values.getInt(index);
    }

    public long decodeToLong(int index) {
        return this.values.getLong(index);
    }

    public long decodeToLongDecimal(int index) {
        return this.values.getLongDecimal(index);
    }

    public float decodeToFloat(int index) {
        return this.values.getFloat(index);
    }

    public double decodeToDouble(int index) {
        return this.values.getDouble(index);
    }

    public byte[] decodeToBinary(int index) {
        switch (this.values.getValueVector().getMinorType()) {
            case VARBINARY: 
            case FIXEDSIZEBINARY: {
                return this.values.getBinary(index);
            }
            case DECIMAL: {
                if (this.binaries == null) {
                    ByteArrayWrapper[] binaries = new ByteArrayWrapper[this.numValues];
                    for (int i = 0; i < this.numValues; ++i) {
                        byte[] bytes = new byte[16];
                        bytes = this.values.copyBinaryDecimal(i, bytes);
                        binaries[i] = new ByteArrayWrapper(bytes);
                    }
                    this.binaries = binaries;
                }
                return this.binaries[index].bytes;
            }
        }
        throw new IllegalArgumentException("Invalid Arrow minor type: " + this.values.getValueVector().getMinorType());
    }

    public UTF8String decodeToUTF8String(int index) {
        return this.values.getUTF8String(index);
    }

    @Override
    public void close() {
        this.values.close();
    }

    private static class ByteArrayWrapper {
        private final byte[] bytes;

        ByteArrayWrapper(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

