/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.comet.shaded.arrow.c.CDataDictionaryProvider;
import org.apache.comet.shaded.arrow.vector.BaseFixedWidthVector;
import org.apache.comet.shaded.arrow.vector.BaseVariableWidthVector;
import org.apache.comet.shaded.arrow.vector.NullVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.Preconditions;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;

public class CometPlainVector
extends CometDecodedVector {
    private final long valueBufferAddress;
    private final boolean isBaseFixedWidthVector;
    private byte booleanByteCache;
    private int booleanByteCacheIndex = -1;

    public CometPlainVector(ValueVector vector, boolean useDecimal128) {
        this(vector, useDecimal128, false);
    }

    public CometPlainVector(ValueVector vector, boolean useDecimal128, boolean isUuid) {
        super(vector, vector.getField(), useDecimal128, isUuid);
        this.valueBufferAddress = vector instanceof NullVector ? -1L : vector.getDataBuffer().memoryAddress();
        this.isBaseFixedWidthVector = this.valueVector instanceof BaseFixedWidthVector;
    }

    @Override
    public void setNumNulls(int numNulls) {
        super.setNumNulls(numNulls);
        this.booleanByteCacheIndex = -1;
    }

    @Override
    public boolean getBoolean(int rowId) {
        int byteIndex = rowId >> 3;
        if (byteIndex != this.booleanByteCacheIndex) {
            this.booleanByteCache = this.getByte(byteIndex);
            this.booleanByteCacheIndex = byteIndex;
        }
        return (this.booleanByteCache >> (rowId & 7) & 1) == 1;
    }

    @Override
    public byte getByte(int rowId) {
        return Platform.getByte(null, (long)(this.valueBufferAddress + (long)rowId));
    }

    @Override
    public short getShort(int rowId) {
        return Platform.getShort(null, (long)(this.valueBufferAddress + (long)rowId * 2L));
    }

    @Override
    public int getInt(int rowId) {
        return Platform.getInt(null, (long)(this.valueBufferAddress + (long)rowId * 4L));
    }

    @Override
    public long getLong(int rowId) {
        return Platform.getLong(null, (long)(this.valueBufferAddress + (long)rowId * 8L));
    }

    @Override
    public long getLongDecimal(int rowId) {
        return Platform.getLong(null, (long)(this.valueBufferAddress + (long)rowId * 16L));
    }

    @Override
    public float getFloat(int rowId) {
        return Platform.getFloat(null, (long)(this.valueBufferAddress + (long)rowId * 4L));
    }

    @Override
    public double getDouble(int rowId) {
        return Platform.getDouble(null, (long)(this.valueBufferAddress + (long)rowId * 8L));
    }

    @Override
    public UTF8String getUTF8String(int rowId) {
        if (!this.isBaseFixedWidthVector) {
            BaseVariableWidthVector varWidthVector = (BaseVariableWidthVector)this.valueVector;
            long offsetBufferAddress = varWidthVector.getOffsetBuffer().memoryAddress();
            int offset = Platform.getInt(null, (long)(offsetBufferAddress + (long)rowId * 4L));
            int length = Platform.getInt(null, (long)(offsetBufferAddress + ((long)rowId + 1L) * 4L)) - offset;
            return UTF8String.fromAddress(null, (long)(this.valueBufferAddress + (long)offset), (int)length);
        }
        BaseFixedWidthVector fixedWidthVector = (BaseFixedWidthVector)this.valueVector;
        int length = fixedWidthVector.getTypeWidth();
        int offset = rowId * length;
        byte[] result = new byte[length];
        Platform.copyMemory(null, (long)(this.valueBufferAddress + (long)offset), (Object)result, (long)Platform.BYTE_ARRAY_OFFSET, (long)length);
        if (!this.isUuid) {
            return UTF8String.fromBytes((byte[])result);
        }
        return UTF8String.fromString((String)CometPlainVector.convertToUuid(result).toString());
    }

    @Override
    public byte[] getBinary(int rowId) {
        int length;
        int offset;
        if (this.valueVector instanceof BaseVariableWidthVector) {
            BaseVariableWidthVector varWidthVector = (BaseVariableWidthVector)this.valueVector;
            long offsetBufferAddress = varWidthVector.getOffsetBuffer().memoryAddress();
            offset = Platform.getInt(null, (long)(offsetBufferAddress + (long)rowId * 4L));
            length = Platform.getInt(null, (long)(offsetBufferAddress + ((long)rowId + 1L) * 4L)) - offset;
        } else if (this.valueVector instanceof BaseFixedWidthVector) {
            BaseFixedWidthVector fixedWidthVector = (BaseFixedWidthVector)this.valueVector;
            length = fixedWidthVector.getTypeWidth();
            offset = rowId * length;
        } else {
            throw new RuntimeException("Unsupported binary vector type: " + this.valueVector.getName());
        }
        byte[] result = new byte[length];
        Platform.copyMemory(null, (long)(this.valueBufferAddress + (long)offset), (Object)result, (long)Platform.BYTE_ARRAY_OFFSET, (long)length);
        return result;
    }

    @Override
    public CDataDictionaryProvider getDictionaryProvider() {
        return null;
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.valueBufferAddress == -1L || super.isNullAt(rowId);
    }

    @Override
    public CometVector slice(int offset, int length) {
        TransferPair tp = this.valueVector.getTransferPair(this.valueVector.getAllocator());
        tp.splitAndTransfer(offset, length);
        return new CometPlainVector(tp.getTo(), this.useDecimal128);
    }

    private static UUID convertToUuid(byte[] buf) {
        Preconditions.checkArgument((buf.length == 16 ? 1 : 0) != 0, (String)"UUID require 16 bytes");
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.BIG_ENDIAN);
        long mostSigBits = bb.getLong();
        long leastSigBits = bb.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

