/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import org.apache.comet.CometConf$;
import org.apache.comet.expressions.CometCast$;
import org.apache.comet.expressions.CometEvalMode$;
import org.apache.comet.expressions.Compatible;
import org.apache.comet.expressions.Incompatible;
import org.apache.comet.expressions.SupportLevel;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.mutable.ListBuffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GenerateDocs$ {
    public static GenerateDocs$ MODULE$;

    static {
        new GenerateDocs$();
    }

    public void main(String[] args) {
        this.generateConfigReference();
        this.generateCompatibilityGuide();
    }

    private void generateConfigReference() {
        String templateFilename = "docs/templates/configs-template.md";
        String outputFilename = "docs/source/user-guide/configs.md";
        BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(outputFilename));
        Source$.MODULE$.fromFile(templateFilename, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            GenerateDocs$.$anonfun$generateConfigReference$1(w, line);
            return BoxedUnit.UNIT;
        });
        w.close();
    }

    private void generateCompatibilityGuide() {
        String templateFilename = "docs/templates/compatibility-template.md";
        String outputFilename = "docs/source/user-guide/compatibility.md";
        BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(outputFilename));
        Source$.MODULE$.fromFile(templateFilename, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            GenerateDocs$.$anonfun$generateCompatibilityGuide$1(w, line);
            return BoxedUnit.UNIT;
        });
        w.close();
    }

    public static final /* synthetic */ void $anonfun$generateConfigReference$1(BufferedOutputStream w$1, String line) {
        String string = line.trim();
        String string2 = "<!--CONFIG_TABLE-->";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ListBuffer publicConfigs = (ListBuffer)CometConf$.MODULE$.allConfs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isPublic()));
            ListBuffer confs = (ListBuffer)publicConfigs.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.key(), (Ordering)Ordering.String$.MODULE$);
            w$1.write("| Config | Description | Default Value |\n".getBytes());
            w$1.write("|--------|-------------|---------------|\n".getBytes());
            confs.foreach((Function1 & Serializable & scala.Serializable)conf -> {
                w$1.write(new StringBuilder(11).append("| ").append(conf.key()).append(" | ").append(conf.doc().trim()).append(" | ").append(conf.defaultValueString()).append(" |\n").toString().getBytes());
                return BoxedUnit.UNIT;
            });
        } else {
            w$1.write(new StringBuilder(1).append(line.trim()).append("\n").toString().getBytes());
        }
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$3(DataType fromType$1, BufferedOutputStream w$2, DataType toType) {
        block3: {
            if (!Cast$.MODULE$.canCast(fromType$1, toType)) break block3;
            DataType dataType = fromType$1;
            DataType dataType2 = toType;
            if ((dataType != null ? !dataType.equals(dataType2) : dataType2 != null) || fromType$1.typeName().contains("decimal")) {
                String fromTypeName = fromType$1.typeName().replace("(10,2)", "");
                String toTypeName = toType.typeName().replace("(10,2)", "");
                SupportLevel supportLevel = CometCast$.MODULE$.isSupported(fromType$1, toType, (Option<String>)None$.MODULE$, CometEvalMode$.MODULE$.LEGACY());
                if (supportLevel instanceof Compatible) {
                    Compatible compatible = (Compatible)supportLevel;
                    Option<String> notes = compatible.notes();
                    String notesStr = ((String)notes.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).trim();
                    w$2.write(new StringBuilder(11).append("| ").append(fromTypeName).append(" | ").append(toTypeName).append(" | ").append(notesStr).append(" |\n").toString().getBytes());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$2(BufferedOutputStream w$2, DataType fromType) {
        CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable & scala.Serializable)toType -> {
            GenerateDocs$.$anonfun$generateCompatibilityGuide$3(fromType, w$2, toType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$6(DataType fromType$2, BufferedOutputStream w$2, DataType toType) {
        block3: {
            if (!Cast$.MODULE$.canCast(fromType$2, toType)) break block3;
            DataType dataType = fromType$2;
            DataType dataType2 = toType;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                String fromTypeName = fromType$2.typeName().replace("(10,2)", "");
                String toTypeName = toType.typeName().replace("(10,2)", "");
                SupportLevel supportLevel = CometCast$.MODULE$.isSupported(fromType$2, toType, (Option<String>)None$.MODULE$, CometEvalMode$.MODULE$.LEGACY());
                if (supportLevel instanceof Incompatible) {
                    Incompatible incompatible = (Incompatible)supportLevel;
                    Option<String> notes = incompatible.notes();
                    String notesStr = ((String)notes.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).trim();
                    w$2.write(new StringBuilder(12).append("| ").append(fromTypeName).append(" | ").append(toTypeName).append("  | ").append(notesStr).append(" |\n").toString().getBytes());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$5(BufferedOutputStream w$2, DataType fromType) {
        CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable & scala.Serializable)toType -> {
            GenerateDocs$.$anonfun$generateCompatibilityGuide$6(fromType, w$2, toType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$1(BufferedOutputStream w$2, String line) {
        String string = line.trim();
        String string2 = "<!--COMPAT_CAST_TABLE-->";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            w$2.write("| From Type | To Type | Notes |\n".getBytes());
            w$2.write("|-|-|-|\n".getBytes());
            CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable & scala.Serializable)fromType -> {
                GenerateDocs$.$anonfun$generateCompatibilityGuide$2(w$2, fromType);
                return BoxedUnit.UNIT;
            });
        } else {
            String string3 = line.trim();
            String string4 = "<!--INCOMPAT_CAST_TABLE-->";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                w$2.write("| From Type | To Type | Notes |\n".getBytes());
                w$2.write("|-|-|-|\n".getBytes());
                CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable & scala.Serializable)fromType -> {
                    GenerateDocs$.$anonfun$generateCompatibilityGuide$5(w$2, fromType);
                    return BoxedUnit.UNIT;
                });
            } else {
                w$2.write(new StringBuilder(1).append(line.trim()).append("\n").toString().getBytes());
            }
        }
    }

    private GenerateDocs$() {
        MODULE$ = this;
    }
}

