/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.CometConf;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOptions {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOptions.class);
    public static final int S3A_MAX_EXPECTED_PARALLELISM = 32;
    public static final String S3A_MAXIMUM_CONNECTIONS = "fs.s3a.connection.maximum";
    public static final int S3A_DEFAULT_MAX_HTTP_CONNECTIONS = 96;
    public static final String S3A_READAHEAD_RANGE = "fs.s3a.readahead.range";
    public static final long COMET_DEFAULT_READAHEAD_RANGE = 0x100000L;
    private final boolean parallelIOEnabled;
    private final int parallelIOThreadPoolSize;
    private final boolean ioMergeRanges;
    private final int ioMergeRangesDelta;
    private final boolean adjustReadRangeSkew;

    ReadOptions(boolean parallelIOEnabled, int parallelIOThreadPoolSize, boolean ioMergeRanges, int ioMergeRangesDelta, boolean adjustReadRangeSkew) {
        this.parallelIOEnabled = parallelIOEnabled;
        this.parallelIOThreadPoolSize = parallelIOThreadPoolSize;
        this.ioMergeRanges = ioMergeRanges;
        this.ioMergeRangesDelta = ioMergeRangesDelta;
        this.adjustReadRangeSkew = adjustReadRangeSkew;
    }

    public boolean isParallelIOEnabled() {
        return this.parallelIOEnabled;
    }

    public int parallelIOThreadPoolSize() {
        return this.parallelIOThreadPoolSize;
    }

    public boolean isIOMergeRangesEnabled() {
        return this.ioMergeRanges;
    }

    public int getIOMergeRangesDelta() {
        return this.ioMergeRangesDelta;
    }

    public boolean adjustReadRangesSkew() {
        return this.adjustReadRangeSkew;
    }

    public static Builder builder(Configuration conf) {
        return new Builder(conf);
    }

    public static class Builder {
        private final Configuration conf;
        private boolean parallelIOEnabled;
        private int parallelIOThreadPoolSize;
        private boolean ioMergeRanges;
        private int ioMergeRangesDelta;
        private boolean adjustReadRangeSkew;

        public Builder enableParallelIO(boolean b) {
            this.parallelIOEnabled = b;
            return this;
        }

        public Builder withParallelIOThreadPoolSize(int numThreads) {
            this.parallelIOThreadPoolSize = numThreads;
            return this;
        }

        public Builder enableIOMergeRanges(boolean enableIOMergeRanges) {
            this.ioMergeRanges = enableIOMergeRanges;
            return this;
        }

        public Builder withIOMergeRangesDelta(int ioMergeRangesDelta) {
            this.ioMergeRangesDelta = ioMergeRangesDelta;
            return this;
        }

        public Builder adjustReadRangeSkew(boolean adjustReadRangeSkew) {
            this.adjustReadRangeSkew = adjustReadRangeSkew;
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this.parallelIOEnabled, this.parallelIOThreadPoolSize, this.ioMergeRanges, this.ioMergeRangesDelta, this.adjustReadRangeSkew);
        }

        public Builder(Configuration conf) {
            this.conf = conf;
            this.parallelIOEnabled = conf.getBoolean(CometConf.COMET_PARQUET_PARALLEL_IO_ENABLED().key(), ((Boolean)CometConf.COMET_PARQUET_PARALLEL_IO_ENABLED().defaultValue().get()).booleanValue());
            this.parallelIOThreadPoolSize = conf.getInt(CometConf.COMET_PARQUET_PARALLEL_IO_THREADS().key(), ((Integer)CometConf.COMET_PARQUET_PARALLEL_IO_THREADS().defaultValue().get()).intValue());
            this.ioMergeRanges = conf.getBoolean(CometConf.COMET_IO_MERGE_RANGES().key(), ((Boolean)CometConf.COMET_IO_MERGE_RANGES().defaultValue().get()).booleanValue());
            this.ioMergeRangesDelta = conf.getInt(CometConf.COMET_IO_MERGE_RANGES_DELTA().key(), ((Integer)CometConf.COMET_IO_MERGE_RANGES_DELTA().defaultValue().get()).intValue());
            this.adjustReadRangeSkew = conf.getBoolean(CometConf.COMET_IO_ADJUST_READRANGE_SKEW().key(), ((Boolean)CometConf.COMET_IO_ADJUST_READRANGE_SKEW().defaultValue().get()).booleanValue());
            this.setS3Config();
        }

        private void setS3Config() {
            int s3ConnectionsMax = 96;
            SparkEnv env = SparkEnv.get();
            int numExecutorCores = 32;
            if (env != null) {
                numExecutorCores = env.conf().getInt("spark.executor.cores", numExecutorCores);
            }
            int parallelReaderThreads = this.parallelIOEnabled ? this.parallelIOThreadPoolSize : 1;
            s3ConnectionsMax = Math.max(numExecutorCores * parallelReaderThreads * 2, s3ConnectionsMax);
            this.setS3ConfIfGreater(this.conf, ReadOptions.S3A_MAXIMUM_CONNECTIONS, s3ConnectionsMax);
            this.setS3ConfIfGreater(this.conf, ReadOptions.S3A_READAHEAD_RANGE, 0x100000L);
        }

        private void setS3ConfIfGreater(Configuration conf, String key, int newVal) {
            int maxVal = newVal;
            String curr = conf.get(key);
            if (curr != null && !curr.isEmpty()) {
                maxVal = Math.max(Integer.parseInt(curr), newVal);
            }
            LOG.info("File reader auto configured '{}={}'", (Object)key, (Object)maxVal);
            conf.set(key, Integer.toString(maxVal));
        }

        private void setS3ConfIfGreater(Configuration conf, String key, long newVal) {
            long maxVal = conf.getLongBytes(key, newVal);
            maxVal = Math.max(maxVal, newVal);
            LOG.info("File reader auto configured '{}={}'", (Object)key, (Object)maxVal);
            conf.set(key, Long.toString(maxVal));
        }
    }
}

