/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.comet.parquet.BloomFilterReader;
import org.apache.comet.parquet.DictionaryPageReader;
import org.apache.comet.parquet.FileReader;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.dictionarylevel.DictionaryFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.SchemaCompatibilityValidator;
import org.apache.parquet.filter2.statisticslevel.StatisticsFilter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.schema.MessageType;

public class RowGroupFilter
implements FilterCompat.Visitor<List<BlockMetaData>> {
    private final List<BlockMetaData> blocks;
    private final MessageType schema;
    private final List<FilterLevel> levels;
    private final FileReader reader;

    public static List<BlockMetaData> filterRowGroups(List<FilterLevel> levels, FilterCompat.Filter filter, List<BlockMetaData> blocks, FileReader reader) {
        return (List)filter.accept((FilterCompat.Visitor)new RowGroupFilter(levels, blocks, reader));
    }

    private RowGroupFilter(List<FilterLevel> levels, List<BlockMetaData> blocks, FileReader reader) {
        this.levels = levels;
        this.blocks = blocks;
        this.reader = reader;
        this.schema = reader.getFileMetaData().getSchema();
    }

    public List<BlockMetaData> visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
        FilterPredicate filterPredicate = filterPredicateCompat.getFilterPredicate();
        SchemaCompatibilityValidator.validate((FilterPredicate)filterPredicate, (MessageType)this.schema);
        ArrayList<BlockMetaData> filteredBlocks = new ArrayList<BlockMetaData>();
        for (BlockMetaData block : this.blocks) {
            boolean drop = false;
            if (this.levels.contains((Object)FilterLevel.STATISTICS)) {
                drop = StatisticsFilter.canDrop((FilterPredicate)filterPredicate, (List)block.getColumns());
            }
            if (!drop && this.levels.contains((Object)FilterLevel.DICTIONARY)) {
                drop = DictionaryFilter.canDrop((FilterPredicate)filterPredicate, (List)block.getColumns(), (DictionaryPageReadStore)new DictionaryPageReader(block, this.reader.getFileMetaData().getFileDecryptor(), this.reader.getInputStream(), this.reader.getOptions()));
            }
            if (!drop && this.levels.contains((Object)FilterLevel.BLOOMFILTER)) {
                drop = (Boolean)filterPredicate.accept((FilterPredicate.Visitor)new BloomFilterReader(block, this.reader.getFileMetaData().getFileDecryptor(), this.reader.getInputStream()));
            }
            if (drop) continue;
            filteredBlocks.add(block);
        }
        return filteredBlocks;
    }

    public List<BlockMetaData> visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
        return this.blocks;
    }

    public List<BlockMetaData> visit(FilterCompat.NoOpFilter noOpFilter) {
        return this.blocks;
    }

    public static enum FilterLevel {
        STATISTICS,
        DICTIONARY,
        BLOOMFILTER;

    }
}

