/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.parquet.MetadataColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.parquet.TypeUtil;
import org.apache.spark.sql.types.StructField;

public class RowIndexColumnReader
extends MetadataColumnReader {
    private final long[] indices;
    private long offset;

    public RowIndexColumnReader(StructField field, int batchSize, long[] indices) {
        super(field.dataType(), TypeUtil.convertToParquet(field), false, false);
        this.indices = indices;
        this.setBatchSize(batchSize);
    }

    @Override
    public void readBatch(int total) {
        Native.resetBatch(this.nativeHandle);
        int count = Native.setIndices(this.nativeHandle, this.offset, total, this.indices);
        this.offset += (long)count;
        super.readBatch(count);
    }
}

