/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.c;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.comet.shaded.arrow.c.ArrowArray;
import org.apache.comet.shaded.arrow.c.ArrowArrayStream;
import org.apache.comet.shaded.arrow.c.ArrowSchema;
import org.apache.comet.shaded.arrow.c.CDataDictionaryProvider;
import org.apache.comet.shaded.arrow.c.Data;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.util.Preconditions;
import org.apache.comet.shaded.arrow.vector.dictionary.Dictionary;
import org.apache.comet.shaded.arrow.vector.ipc.ArrowReader;
import org.apache.comet.shaded.arrow.vector.types.pojo.Schema;

final class ArrowArrayStreamReader
extends ArrowReader {
    private final ArrowArrayStream ownedStream;
    private final CDataDictionaryProvider provider = new CDataDictionaryProvider();

    ArrowArrayStreamReader(BufferAllocator allocator, ArrowArrayStream stream) {
        super(allocator);
        ArrowArrayStream.Snapshot snapshot = stream.snapshot();
        Preconditions.checkState(snapshot.release != 0L, "Cannot import released ArrowArrayStream");
        this.ownedStream = ArrowArrayStream.allocateNew(allocator);
        this.ownedStream.save(snapshot);
        stream.markReleased();
        stream.close();
    }

    @Override
    public Map<Long, Dictionary> getDictionaryVectors() {
        return this.provider.getDictionaryIds().stream().collect(Collectors.toMap(Function.identity(), this.provider::lookup));
    }

    @Override
    public Dictionary lookup(long id) {
        return this.provider.lookup(id);
    }

    @Override
    public boolean loadNextBatch() throws IOException {
        try (ArrowArray array = ArrowArray.allocateNew(this.allocator);){
            this.ownedStream.getNext(array);
            if (array.snapshot().release == 0L) {
                boolean bl = false;
                return bl;
            }
            Data.importIntoVectorSchemaRoot(this.allocator, array, this.getVectorSchemaRoot(), this.provider);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public long bytesRead() {
        return 0L;
    }

    @Override
    protected void closeReadSource() {
        this.ownedStream.release();
        this.ownedStream.close();
        this.provider.close();
    }

    @Override
    protected Schema readSchema() throws IOException {
        try (ArrowSchema schema = ArrowSchema.allocateNew(this.allocator);){
            this.ownedStream.getSchema(schema);
            Schema schema2 = Data.importSchema(this.allocator, schema, this.provider);
            return schema2;
        }
    }
}

