/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.memory;

import java.lang.reflect.Field;
import org.apache.comet.shaded.arrow.memory.AllocationManager;
import org.apache.comet.shaded.arrow.memory.CheckAllocator;
import org.apache.comet.shaded.arrow.util.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAllocationManagerOption {
    public static final String ALLOCATION_MANAGER_TYPE_ENV_NAME = "ARROW_ALLOCATION_MANAGER_TYPE";
    public static final String ALLOCATION_MANAGER_TYPE_PROPERTY_NAME = "arrow.allocation.manager.type";
    static final Logger LOGGER = LoggerFactory.getLogger(DefaultAllocationManagerOption.class);
    private static  @Nullable AllocationManager.Factory DEFAULT_ALLOCATION_MANAGER_FACTORY = null;

    @VisibleForTesting
    public static AllocationManagerType getDefaultAllocationManagerType() {
        AllocationManagerType ret = AllocationManagerType.Unknown;
        try {
            String envValue = System.getenv(ALLOCATION_MANAGER_TYPE_ENV_NAME);
            ret = AllocationManagerType.valueOf(envValue);
        }
        catch (IllegalArgumentException | NullPointerException envValue) {
            // empty catch block
        }
        try {
            String propValue = System.getProperty(ALLOCATION_MANAGER_TYPE_PROPERTY_NAME);
            ret = AllocationManagerType.valueOf(propValue);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return ret;
    }

    static AllocationManager.Factory getDefaultAllocationManagerFactory() {
        if (DEFAULT_ALLOCATION_MANAGER_FACTORY != null) {
            return DEFAULT_ALLOCATION_MANAGER_FACTORY;
        }
        AllocationManagerType type = DefaultAllocationManagerOption.getDefaultAllocationManagerType();
        switch (type) {
            case Netty: {
                DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getNettyFactory();
                break;
            }
            case Unsafe: {
                DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getUnsafeFactory();
                break;
            }
            case Unknown: {
                LOGGER.info("allocation manager type not specified, using netty as the default type");
                DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getFactory(CheckAllocator.check());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown allocation manager type: " + (Object)((Object)type));
            }
        }
        return DEFAULT_ALLOCATION_MANAGER_FACTORY;
    }

    private static AllocationManager.Factory getFactory(String clazzName) {
        try {
            Field field = Class.forName(clazzName).getDeclaredField("FACTORY");
            field.setAccessible(true);
            return (AllocationManager.Factory)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Allocation Manager for " + clazzName, e);
        }
    }

    private static AllocationManager.Factory getUnsafeFactory() {
        try {
            return DefaultAllocationManagerOption.getFactory("org.apache.comet.shaded.arrow.memory.unsafe.UnsafeAllocationManager");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Please add arrow-memory-unsafe to your classpath, No DefaultAllocationManager found to instantiate an UnsafeAllocationManager", e);
        }
    }

    private static AllocationManager.Factory getNettyFactory() {
        try {
            return DefaultAllocationManagerOption.getFactory("org.apache.comet.shaded.arrow.memory.netty.NettyAllocationManager");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Please add arrow-memory-netty to your classpath, No DefaultAllocationManager found to instantiate an NettyAllocationManager", e);
        }
    }

    public static enum AllocationManagerType {
        Netty,
        Unsafe,
        Unknown;

    }
}

