/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.guava.collect;

import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.comet.shaded.guava.annotations.GwtCompatible;
import org.apache.comet.shaded.guava.base.Predicate;
import org.apache.comet.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import org.apache.comet.shaded.guava.collect.FilteredEntryMultimap;
import org.apache.comet.shaded.guava.collect.FilteredSetMultimap;
import org.apache.comet.shaded.guava.collect.ParametricNullness;
import org.apache.comet.shaded.guava.collect.SetMultimap;
import org.apache.comet.shaded.guava.collect.Sets;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class FilteredEntrySetMultimap<K, V>
extends FilteredEntryMultimap<K, V>
implements FilteredSetMultimap<K, V> {
    FilteredEntrySetMultimap(SetMultimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        super(unfiltered, predicate);
    }

    @Override
    public SetMultimap<K, V> unfiltered() {
        return (SetMultimap)this.unfiltered;
    }

    @Override
    public Set<V> get(@ParametricNullness K key) {
        return (Set)super.get(key);
    }

    @Override
    public Set<V> removeAll(@CheckForNull Object key) {
        return (Set)super.removeAll(key);
    }

    @Override
    public Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        return (Set)super.replaceValues(key, values);
    }

    @Override
    Set<Map.Entry<K, V>> createEntries() {
        return Sets.filter(this.unfiltered().entries(), this.entryPredicate());
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }
}

