/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.guava.collect;

import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.comet.shaded.guava.annotations.GwtCompatible;
import org.apache.comet.shaded.guava.annotations.GwtIncompatible;
import org.apache.comet.shaded.guava.annotations.J2ktIncompatible;
import org.apache.comet.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import org.apache.comet.shaded.guava.collect.ImmutableList;
import org.apache.comet.shaded.guava.collect.IndexedImmutableSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class JdkBackedImmutableSet<E>
extends IndexedImmutableSet<E> {
    private final Set<?> delegate;
    private final ImmutableList<E> delegateList;

    JdkBackedImmutableSet(Set<?> delegate, ImmutableList<E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    @Override
    E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.delegate.contains(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.delegateList.size();
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

