/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.IOException;
import org.apache.spark.TaskContext$;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;

public class CometTaskMemoryManager {
    private final long id;
    private final TaskMemoryManager internal;
    private final NativeMemoryConsumer nativeMemoryConsumer;

    public CometTaskMemoryManager(long id) {
        this.id = id;
        this.internal = TaskContext$.MODULE$.get().taskMemoryManager();
        this.nativeMemoryConsumer = new NativeMemoryConsumer();
    }

    public long acquireMemory(long size) {
        return this.internal.acquireExecutionMemory(size, (MemoryConsumer)this.nativeMemoryConsumer);
    }

    public void releaseMemory(long size) {
        this.internal.releaseExecutionMemory(size, (MemoryConsumer)this.nativeMemoryConsumer);
    }

    private class NativeMemoryConsumer
    extends MemoryConsumer {
        protected NativeMemoryConsumer() {
            super(CometTaskMemoryManager.this.internal, 0L, MemoryMode.OFF_HEAP);
        }

        public long spill(long size, MemoryConsumer trigger) throws IOException {
            return 0L;
        }

        public String toString() {
            return String.format("NativeMemoryConsumer(id=%)", CometTaskMemoryManager.this.id);
        }
    }
}

