/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.comet;

import java.io.IOException;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.shuffle.comet.CometShuffleMemoryAllocatorTrait;
import org.apache.spark.unsafe.memory.MemoryBlock;

public final class CometUnifiedShuffleMemoryAllocator
extends CometShuffleMemoryAllocatorTrait {
    CometUnifiedShuffleMemoryAllocator(TaskMemoryManager taskMemoryManager, long pageSize) {
        super(taskMemoryManager, pageSize, MemoryMode.OFF_HEAP);
        if (taskMemoryManager.getTungstenMemoryMode() != MemoryMode.OFF_HEAP) {
            throw new IllegalArgumentException("CometUnifiedShuffleMemoryAllocator should be used with off-heap memory mode, but got " + taskMemoryManager.getTungstenMemoryMode());
        }
    }

    public long spill(long l, MemoryConsumer memoryConsumer) throws IOException {
        return 0L;
    }

    @Override
    public synchronized MemoryBlock allocate(long required) {
        return this.allocatePage(required);
    }

    @Override
    public synchronized void free(MemoryBlock block) {
        this.freePage(block);
    }

    @Override
    public long getOffsetInPage(long pagePlusOffsetAddress) {
        return this.taskMemoryManager.getOffsetInPage(pagePlusOffsetAddress);
    }

    public long encodePageNumberAndOffset(int pageNumber, long offsetInPage) {
        return TaskMemoryManager.encodePageNumberAndOffset((int)pageNumber, (long)offsetInPage);
    }

    @Override
    public long encodePageNumberAndOffset(MemoryBlock page, long offsetInPage) {
        return this.encodePageNumberAndOffset(page.pageNumber, offsetInPage - page.getBaseOffset());
    }
}

