/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.comet.CometBatchPartition;
import org.apache.spark.sql.comet.execution.shuffle.ArrowReaderIterator;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001=4A\u0001C\u0005\u0001)!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!i\u0003A!A!\u0002\u0013q\u0003\"B \u0001\t\u0003\u0001\u0005\"\u0002$\u0001\t\u0003:\u0005\"\u0002'\u0001\t\u0003j\u0005\"B1\u0001\t\u0013\u0011'!D\"p[\u0016$()\u0019;dQJ#EI\u0003\u0002\u000b\u0017\u0005)1m\\7fi*\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0006\t\u0004-eYR\"A\f\u000b\u0005ai\u0011a\u0001:eI&\u0011!d\u0006\u0002\u0004%\u0012#\u0005C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\f\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0003Au\u0011QbQ8mk6t\u0017M\u001d\"bi\u000eD\u0017AA:d!\t\u0019C%D\u0001\u000e\u0013\t)SB\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0004\u0013:$\u0018!\u0002<bYV,\u0007cA\u00183i5\t\u0001G\u0003\u00022\u001b\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003gA\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007!*t'\u0003\u00027S\t)\u0011I\u001d:bsB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0003S>T!\u0001P\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003}e\u0012\u0011c\u00115v].,GMQ=uK\n+hMZ3s\u0003\u0019a\u0014N\\5u}Q!\u0011i\u0011#F!\t\u0011\u0005!D\u0001\n\u0011\u0015\tC\u00011\u0001#\u0011\u00151C\u00011\u0001(\u0011\u0015iC\u00011\u0001/\u000359W\r\u001e)beRLG/[8ogV\t\u0001\nE\u0002)k%\u0003\"a\t&\n\u0005-k!!\u0003)beRLG/[8o\u0003\u001d\u0019w.\u001c9vi\u0016$2A\u0014.]!\ryuk\u0007\b\u0003!Vs!!\u0015+\u000e\u0003IS!aU\n\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001,*\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0011%#XM]1u_JT!AV\u0015\t\u000bm3\u0001\u0019A%\u0002\u000bM\u0004H.\u001b;\t\u000bu3\u0001\u0019\u00010\u0002\u000f\r|g\u000e^3yiB\u00111eX\u0005\u0003A6\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006iA-Z2pI\u0016\u0014\u0015\r^2iKN$2AT2f\u0011\u0015!w\u00011\u00018\u0003\u0015\u0011\u0017\u0010^3t\u0011\u00151w\u00011\u0001h\u0003\u0019\u0019x.\u001e:dKB\u0011\u0001\u000e\u001c\b\u0003S*\u0004\"!U\u0015\n\u0005-L\u0013A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a[\u0015")
public class CometBatchRDD
extends RDD<ColumnarBatch> {
    private final int numPartitions;
    private final Broadcast<ChunkedByteBuffer[]> value;

    public Partition[] getPartitions() {
        return (Partition[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions).toArray(ClassTag$.MODULE$.Int()))).map((Function1 & Serializable & scala.Serializable)i -> CometBatchRDD.$anonfun$getPartitions$1(this, BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
    }

    public Iterator<ColumnarBatch> compute(Partition split, TaskContext context) {
        CometBatchPartition partition = (CometBatchPartition)split;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partition.value().value())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> this.decodeBatches((ChunkedByteBuffer)x$3, this.getClass().getSimpleName()));
    }

    private Iterator<ColumnarBatch> decodeBatches(ChunkedByteBuffer bytes, String source) {
        if (bytes.size() == 0L) {
            return package$.MODULE$.Iterator().empty();
        }
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(SparkEnv$.MODULE$.get().conf());
        InputStream cbbis = bytes.toInputStream(bytes.toInputStream$default$1());
        DataInputStream ins = new DataInputStream(codec.compressedInputStream(cbbis));
        return new ArrowReaderIterator(Channels.newChannel(ins), source);
    }

    public static final /* synthetic */ CometBatchPartition $anonfun$getPartitions$1(CometBatchRDD $this, int i) {
        return new CometBatchPartition(i, $this.value);
    }

    public CometBatchRDD(SparkContext sc, int numPartitions, Broadcast<ChunkedByteBuffer[]> value) {
        this.numPartitions = numPartitions;
        this.value = value;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ColumnarBatch.class));
    }
}

