/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe;

import dlshade.com.scurrilous.circe.Hashes;
import dlshade.com.scurrilous.circe.IncrementalIntHash;
import dlshade.com.scurrilous.circe.IncrementalLongHash;
import dlshade.com.scurrilous.circe.StatefulHash;
import dlshade.com.scurrilous.circe.StatelessIntHash;
import dlshade.com.scurrilous.circe.StatelessLongHash;
import dlshade.com.scurrilous.circe.params.CrcParameters;
import dlshade.com.scurrilous.circe.params.MurmurHash3Parameters;
import dlshade.com.scurrilous.circe.params.MurmurHash3Variant;
import dlshade.com.scurrilous.circe.params.SimpleHashParameters;
import dlshade.com.scurrilous.circe.params.SipHash24Parameters;

public final class CommonHashes {
    private CommonHashes() {
    }

    public static IncrementalIntHash crc32() {
        return Hashes.getIncrementalInt(CrcParameters.CRC32);
    }

    public static IncrementalIntHash crc32c() {
        return Hashes.getIncrementalInt(CrcParameters.CRC32C);
    }

    public static IncrementalLongHash crc64() {
        return Hashes.getIncrementalLong(CrcParameters.CRC64);
    }

    public static StatelessIntHash murmur3_32() {
        return Hashes.getStatelessInt(new MurmurHash3Parameters(MurmurHash3Variant.X86_32));
    }

    public static StatelessIntHash murmur3_32(int seed) {
        return Hashes.getStatelessInt(new MurmurHash3Parameters(MurmurHash3Variant.X86_32, seed));
    }

    public static StatefulHash murmur3_128() {
        return Hashes.createStateful(new MurmurHash3Parameters(MurmurHash3Variant.X64_128));
    }

    public static StatefulHash murmur3_128(int seed) {
        return Hashes.createStateful(new MurmurHash3Parameters(MurmurHash3Variant.X64_128, seed));
    }

    public static StatelessLongHash sipHash24() {
        return Hashes.getStatelessLong(new SipHash24Parameters());
    }

    public static StatelessLongHash sipHash24(long seedLow, long seedHigh) {
        return Hashes.getStatelessLong(new SipHash24Parameters(seedLow, seedHigh));
    }

    public static StatefulHash md5() {
        return Hashes.createStateful(SimpleHashParameters.MD5);
    }

    public static StatefulHash sha1() {
        return Hashes.createStateful(SimpleHashParameters.SHA1);
    }

    public static StatefulHash sha256() {
        return Hashes.createStateful(SimpleHashParameters.SHA256);
    }

    public static StatefulHash sha384() {
        return Hashes.createStateful(SimpleHashParameters.SHA384);
    }

    public static StatefulHash sha512() {
        return Hashes.createStateful(SimpleHashParameters.SHA512);
    }
}

