/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe.impl;

import dlshade.com.scurrilous.circe.IncrementalIntHash;
import dlshade.com.scurrilous.circe.StatefulIntHash;
import dlshade.com.scurrilous.circe.impl.IncrementalIntStatefulHash;
import java.nio.ByteBuffer;

public abstract class AbstractIncrementalIntHash
implements IncrementalIntHash {
    @Override
    public boolean supportsUnsafe() {
        return false;
    }

    @Override
    public StatefulIntHash createStateful() {
        return new IncrementalIntStatefulHash(this);
    }

    @Override
    public int calculate(byte[] input) {
        return this.resume(this.initial(), input);
    }

    @Override
    public int calculate(byte[] input, int index, int length) {
        return this.resume(this.initial(), input, index, length);
    }

    @Override
    public int calculate(ByteBuffer input) {
        return this.resume(this.initial(), input);
    }

    @Override
    public int calculate(long address, long length) {
        return this.resume(this.initial(), address, length);
    }

    @Override
    public int resume(int current, byte[] input) {
        return this.resumeUnchecked(current, input, 0, input.length);
    }

    @Override
    public int resume(int current, byte[] input, int index, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index + length > input.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.resumeUnchecked(current, input, index, length);
    }

    @Override
    public int resume(int current, ByteBuffer input) {
        int index;
        byte[] array;
        int length = input.remaining();
        if (input.hasArray()) {
            array = input.array();
            index = input.arrayOffset() + input.position();
            input.position(input.limit());
        } else {
            array = new byte[length];
            index = 0;
            input.get(array);
        }
        return this.resumeUnchecked(current, array, index, length);
    }

    @Override
    public int resume(int current, long address, long length) {
        throw new UnsupportedOperationException();
    }

    protected abstract int initial();

    protected abstract int resumeUnchecked(int var1, byte[] var2, int var3, int var4);
}

