/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe.impl;

import dlshade.com.scurrilous.circe.StatefulHash;
import dlshade.com.scurrilous.circe.StatefulIntHash;
import dlshade.com.scurrilous.circe.StatelessIntHash;
import dlshade.com.scurrilous.circe.impl.AbstractIncrementalIntHash;
import dlshade.com.scurrilous.circe.impl.AbstractStatefulHash;
import java.nio.ByteBuffer;

class IncrementalIntStatefulHash
extends AbstractStatefulHash
implements StatefulIntHash {
    final AbstractIncrementalIntHash stateless;
    int current;

    IncrementalIntStatefulHash(AbstractIncrementalIntHash stateless) {
        this.stateless = stateless;
    }

    @Override
    public StatelessIntHash asStateless() {
        return this.stateless;
    }

    @Override
    public String algorithm() {
        return this.stateless.algorithm();
    }

    @Override
    public int length() {
        return this.stateless.length();
    }

    @Override
    public boolean supportsUnsafe() {
        return this.stateless.supportsUnsafe();
    }

    @Override
    public StatefulHash createNew() {
        return new IncrementalIntStatefulHash(this.stateless);
    }

    @Override
    public boolean supportsIncremental() {
        return true;
    }

    @Override
    public void reset() {
        this.current = this.stateless.initial();
    }

    @Override
    public void update(ByteBuffer input) {
        this.current = this.stateless.resume(this.current, input);
    }

    @Override
    public void update(long address, long length) {
        this.current = this.stateless.resume(this.current, address, length);
    }

    @Override
    protected void updateUnchecked(byte[] input, int index, int length) {
        this.current = this.stateless.resumeUnchecked(this.current, input, index, length);
    }

    @Override
    public int getInt() {
        return this.current;
    }

    @Override
    public long getLong() {
        return this.current;
    }
}

