/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.auth;

import dlshade.org.apache.bookkeeper.auth.AuthCallbacks;
import dlshade.org.apache.bookkeeper.auth.AuthToken;
import dlshade.org.apache.bookkeeper.auth.BookKeeperPrincipal;
import dlshade.org.apache.bookkeeper.auth.BookieAuthProvider;
import dlshade.org.apache.bookkeeper.auth.ClientAuthProvider;
import dlshade.org.apache.bookkeeper.common.util.ReflectionUtils;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.proto.BookieConnectionPeer;
import dlshade.org.apache.bookkeeper.proto.ClientConnectionPeer;
import java.io.IOException;

public class AuthProviderFactoryFactory {
    public static final String AUTHENTICATION_DISABLED_PLUGIN_NAME = "AuthDisabledPlugin";

    public static BookieAuthProvider.Factory newBookieAuthProviderFactory(ServerConfiguration conf) throws IOException {
        String factoryClassName = conf.getBookieAuthProviderFactoryClass();
        if (factoryClassName == null || factoryClassName.length() == 0) {
            return new AuthenticationDisabledAuthProviderFactory();
        }
        BookieAuthProvider.Factory factory = ReflectionUtils.newInstance(factoryClassName, BookieAuthProvider.Factory.class);
        factory.init(conf);
        return factory;
    }

    public static ClientAuthProvider.Factory newClientAuthProviderFactory(ClientConfiguration conf) throws IOException {
        String factoryClassName = conf.getClientAuthProviderFactoryClass();
        if (factoryClassName == null || factoryClassName.length() == 0) {
            return new NullClientAuthProviderFactory();
        }
        ClientAuthProvider.Factory factory = ReflectionUtils.newInstance(factoryClassName, ClientAuthProvider.Factory.class);
        factory.init(conf);
        return factory;
    }

    private static class NullClientAuthProviderFactory
    implements ClientAuthProvider.Factory {
        private NullClientAuthProviderFactory() {
        }

        @Override
        public String getPluginName() {
            return AuthProviderFactoryFactory.AUTHENTICATION_DISABLED_PLUGIN_NAME;
        }

        @Override
        public void init(ClientConfiguration conf) {
        }

        @Override
        public ClientAuthProvider newProvider(ClientConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
            addr.setAuthorizedId(BookKeeperPrincipal.ANONYMOUS);
            completeCb.operationComplete(0, null);
            return new ClientAuthProvider(){

                @Override
                public void init(AuthCallbacks.GenericCallback<AuthToken> cb) {
                }

                @Override
                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                }
            };
        }
    }

    private static class AuthenticationDisabledAuthProviderFactory
    implements BookieAuthProvider.Factory {
        private AuthenticationDisabledAuthProviderFactory() {
        }

        @Override
        public String getPluginName() {
            return AuthProviderFactoryFactory.AUTHENTICATION_DISABLED_PLUGIN_NAME;
        }

        @Override
        public void init(ServerConfiguration conf) {
        }

        @Override
        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
            completeCb.operationComplete(0, null);
            return new BookieAuthProvider(){

                @Override
                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    addr.setAuthorizedId(BookKeeperPrincipal.ANONYMOUS);
                    cb.operationComplete(0, AuthToken.NULL);
                }
            };
        }
    }
}

