/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.EntryLogger;
import dlshade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import dlshade.org.apache.bookkeeper.bookie.LedgerCache;
import dlshade.org.apache.bookkeeper.bookie.LedgerCacheImpl;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.common.util.Watcher;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.proto.checksum.DigestManager;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.util.DiskChecker;
import dlshade.org.apache.bookkeeper.util.SnapshotMap;
import dlshade.org.apache.commons.lang.time.DurationFormatUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterleavedStorageRegenerateIndexOp {
    private static final Logger LOG = LoggerFactory.getLogger(InterleavedStorageRegenerateIndexOp.class);
    private final ServerConfiguration conf;
    private final Set<Long> ledgerIds;
    private final byte[] masterKey;

    public InterleavedStorageRegenerateIndexOp(ServerConfiguration conf, Set<Long> ledgerIds, byte[] password) throws NoSuchAlgorithmException {
        this.conf = conf;
        this.ledgerIds = ledgerIds;
        this.masterKey = DigestManager.generateMasterKey(password);
    }

    public void initiate(boolean dryRun) throws IOException {
        LOG.info("Starting index rebuilding");
        DiskChecker diskChecker = Bookie.createDiskChecker(this.conf);
        LedgerDirsManager ledgerDirsManager = Bookie.createLedgerDirsManager(this.conf, diskChecker, NullStatsLogger.INSTANCE);
        LedgerDirsManager indexDirsManager = Bookie.createIndexDirsManager(this.conf, diskChecker, NullStatsLogger.INSTANCE, ledgerDirsManager);
        EntryLogger entryLogger = new EntryLogger(this.conf, ledgerDirsManager);
        final LedgerCache ledgerCache = dryRun ? new DryRunLedgerCache() : new LedgerCacheImpl(this.conf, new SnapshotMap<Long, Boolean>(), indexDirsManager, NullStatsLogger.INSTANCE);
        Set<Long> entryLogs = entryLogger.getEntryLogsSet();
        int totalEntryLogs = entryLogs.size();
        int completedEntryLogs = 0;
        long startTime = System.nanoTime();
        LOG.info("Scanning {} entry logs", (Object)totalEntryLogs);
        final HashMap stats = new HashMap();
        for (final long entryLogId : entryLogs) {
            LOG.info("Scanning {}", (Object)entryLogId);
            entryLogger.scanEntryLog(entryLogId, new EntryLogger.EntryLogScanner(){

                @Override
                public void process(long ledgerId, long offset, ByteBuf entry) throws IOException {
                    long entryId = entry.getLong(8);
                    stats.computeIfAbsent(ledgerId, ignore -> new RecoveryStats()).registerEntry(entryId);
                    long location = entryLogId << 32 | offset + 4L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Rebuilding {}:{} at location {} / {}", new Object[]{ledgerId, entryId, location >> 32, location & 0x7FFFFFFEL});
                    }
                    if (!ledgerCache.ledgerExists(ledgerId)) {
                        ledgerCache.setMasterKey(ledgerId, InterleavedStorageRegenerateIndexOp.this.masterKey);
                        ledgerCache.setFenced(ledgerId);
                    }
                    ledgerCache.putEntryOffset(ledgerId, entryId, location);
                }

                @Override
                public boolean accept(long ledgerId) {
                    return InterleavedStorageRegenerateIndexOp.this.ledgerIds.contains(ledgerId);
                }
            });
            ledgerCache.flushLedger(true);
            LOG.info("Completed scanning of log {}.log -- {} / {}", new Object[]{Long.toHexString(entryLogId), ++completedEntryLogs, totalEntryLogs});
        }
        LOG.info("Rebuilding indices done");
        for (long ledgerId : this.ledgerIds) {
            RecoveryStats ledgerStats = (RecoveryStats)stats.get(ledgerId);
            if (ledgerStats == null || ledgerStats.getNumEntries() == 0L) {
                LOG.info(" {} - No entries found", (Object)ledgerId);
                continue;
            }
            LOG.info(" {} - Found {} entries, from {} to {}", new Object[]{ledgerId, ledgerStats.getNumEntries(), ledgerStats.getFirstEntry(), ledgerStats.getLastEntry()});
        }
        LOG.info("Total time: {}", (Object)DurationFormatUtils.formatDurationHMS(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)));
    }

    static class DryRunLedgerCache
    implements LedgerCache {
        DryRunLedgerCache() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean setFenced(long ledgerId) throws IOException {
            return false;
        }

        @Override
        public boolean isFenced(long ledgerId) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        }

        @Override
        public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean ledgerExists(long ledgerId) throws IOException {
            return false;
        }

        @Override
        public void putEntryOffset(long ledger, long entry, long offset) throws IOException {
        }

        @Override
        public long getEntryOffset(long ledger, long entry) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flushLedger(boolean doAll) throws IOException {
        }

        @Override
        public long getLastEntry(long ledgerId) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLastAddConfirmed(long ledgerId) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long updateLastAddConfirmed(long ledgerId, long lac) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteLedger(long ledgerId) throws IOException {
        }

        @Override
        public void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        }

        @Override
        public ByteBuf getExplicitLac(long ledgerId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerCache.PageEntriesIterable listEntries(long ledgerId) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerCache.LedgerIndexMetadata readLedgerIndexMetadata(long ledgerId) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrimitiveIterator.OfLong getEntriesIterator(long ledgerId) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class RecoveryStats {
        long firstEntry = Long.MAX_VALUE;
        long lastEntry = Long.MIN_VALUE;
        long numEntries = 0L;

        RecoveryStats() {
        }

        void registerEntry(long entryId) {
            ++this.numEntries;
            if (entryId < this.firstEntry) {
                this.firstEntry = entryId;
            }
            if (entryId > this.lastEntry) {
                this.lastEntry = entryId;
            }
        }

        long getNumEntries() {
            return this.numEntries;
        }

        long getFirstEntry() {
            return this.firstEntry;
        }

        long getLastEntry() {
            return this.lastEntry;
        }
    }
}

