/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.com.google.common.util.concurrent.SettableFuture;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.Journal;
import dlshade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import dlshade.org.apache.bookkeeper.bookie.LedgerDescriptor;
import dlshade.org.apache.bookkeeper.bookie.LedgerStorage;
import dlshade.org.apache.bookkeeper.client.api.BKException;
import dlshade.org.apache.bookkeeper.common.util.Watcher;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerDescriptorImpl
extends LedgerDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerDescriptorImpl.class);
    final LedgerStorage ledgerStorage;
    private long ledgerId;
    final byte[] masterKey;
    private AtomicBoolean fenceEntryPersisted = new AtomicBoolean();
    private SettableFuture<Boolean> logFenceResult = null;

    LedgerDescriptorImpl(byte[] masterKey, long ledgerId, LedgerStorage ledgerStorage) {
        this.masterKey = masterKey;
        this.ledgerId = ledgerId;
        this.ledgerStorage = ledgerStorage;
    }

    @Override
    void checkAccess(byte[] masterKey) throws BookieException, IOException {
        if (!Arrays.equals(this.masterKey, masterKey)) {
            LOG.error("[{}] Requested master key {} does not match the cached master key {}", new Object[]{this.ledgerId, Arrays.toString(masterKey), Arrays.toString(this.masterKey)});
            throw BookieException.create(-1);
        }
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    boolean setFenced() throws IOException {
        return this.ledgerStorage.setFenced(this.ledgerId);
    }

    @Override
    boolean isFenced() throws IOException {
        return this.ledgerStorage.isFenced(this.ledgerId);
    }

    @Override
    void setExplicitLac(ByteBuf lac) throws IOException {
        this.ledgerStorage.setExplicitLac(this.ledgerId, lac);
    }

    @Override
    ByteBuf getExplicitLac() throws IOException {
        return this.ledgerStorage.getExplicitLac(this.ledgerId);
    }

    @Override
    synchronized SettableFuture<Boolean> fenceAndLogInJournal(Journal journal) throws IOException {
        boolean success = this.setFenced();
        if (success) {
            return this.logFenceEntryInJournal(journal);
        }
        if (this.logFenceResult == null || this.fenceEntryPersisted.get()) {
            SettableFuture<Boolean> result = SettableFuture.create();
            result.set(true);
            return result;
        }
        if (this.logFenceResult.isDone()) {
            return this.logFenceEntryInJournal(journal);
        }
        return this.logFenceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettableFuture<Boolean> logFenceEntryInJournal(Journal journal) {
        SettableFuture<Boolean> result;
        LedgerDescriptorImpl ledgerDescriptorImpl = this;
        synchronized (ledgerDescriptorImpl) {
            this.logFenceResult = SettableFuture.create();
            result = this.logFenceResult;
        }
        ByteBuf entry = LedgerDescriptorImpl.createLedgerFenceEntry(this.ledgerId);
        try {
            journal.logAddEntry(entry, false, (rc, ledgerId, entryId, addr, ctx) -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Record fenced state for ledger {} in journal with rc {}", (Object)ledgerId, BKException.codeLogger(rc));
                }
                if (rc == 0) {
                    this.fenceEntryPersisted.compareAndSet(false, true);
                    result.set(true);
                } else {
                    result.set(false);
                }
            }, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.setException(e);
        }
        return result;
    }

    @Override
    long addEntry(ByteBuf entry) throws IOException, BookieException {
        long ledgerId = entry.getLong(entry.readerIndex());
        if (ledgerId != this.ledgerId) {
            throw new IOException("Entry for ledger " + ledgerId + " was sent to " + this.ledgerId);
        }
        return this.ledgerStorage.addEntry(entry);
    }

    @Override
    ByteBuf readEntry(long entryId) throws IOException {
        return this.ledgerStorage.getEntry(this.ledgerId, entryId);
    }

    @Override
    long getLastAddConfirmed() throws IOException {
        return this.ledgerStorage.getLastAddConfirmed(this.ledgerId);
    }

    @Override
    boolean waitForLastAddConfirmedUpdate(long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        return this.ledgerStorage.waitForLastAddConfirmedUpdate(this.ledgerId, previousLAC, watcher);
    }

    @Override
    void cancelWaitForLastAddConfirmedUpdate(Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.ledgerStorage.cancelWaitForLastAddConfirmedUpdate(this.ledgerId, watcher);
    }

    @Override
    PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException {
        return this.ledgerStorage.getListOfEntriesOfLedger(ledgerId);
    }
}

