/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.storage.ldb;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Iterables;
import dlshade.com.google.common.collect.Lists;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.CheckpointSource;
import dlshade.org.apache.bookkeeper.bookie.Checkpointer;
import dlshade.org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import dlshade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import dlshade.org.apache.bookkeeper.bookie.LedgerCache;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.bookie.LedgerStorage;
import dlshade.org.apache.bookkeeper.bookie.StateManager;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorageStats;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.EntryLocationIndex;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.SingleDirectoryDbLedgerStorage;
import dlshade.org.apache.bookkeeper.common.util.MathUtils;
import dlshade.org.apache.bookkeeper.common.util.Watcher;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.util.DiskChecker;
import dlshade.org.apache.commons.lang3.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLedgerStorage
implements LedgerStorage {
    private static final Logger log = LoggerFactory.getLogger(DbLedgerStorage.class);
    public static final String WRITE_CACHE_MAX_SIZE_MB = "dbStorage_writeCacheMaxSizeMb";
    public static final String READ_AHEAD_CACHE_MAX_SIZE_MB = "dbStorage_readAheadCacheMaxSizeMb";
    static final String MAX_THROTTLE_TIME_MILLIS = "dbStorage_maxThrottleTimeMs";
    private static final int MB = 0x100000;
    private static final long DEFAULT_WRITE_CACHE_MAX_SIZE_MB = (long)(0.25 * (double)PlatformDependent.maxDirectMemory()) / 0x100000L;
    private static final long DEFAULT_READ_CACHE_MAX_SIZE_MB = (long)(0.25 * (double)PlatformDependent.maxDirectMemory()) / 0x100000L;
    private int numberOfDirs;
    private List<SingleDirectoryDbLedgerStorage> ledgerStorageList;
    private ScheduledExecutorService gcExecutor;
    private DbLedgerStorageStats stats;
    protected ByteBufAllocator allocator;

    @Override
    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        long writeCacheMaxSize = DbLedgerStorage.getLongVariableOrDefault(conf, WRITE_CACHE_MAX_SIZE_MB, DEFAULT_WRITE_CACHE_MAX_SIZE_MB) * 0x100000L;
        long readCacheMaxSize = DbLedgerStorage.getLongVariableOrDefault(conf, READ_AHEAD_CACHE_MAX_SIZE_MB, DEFAULT_READ_CACHE_MAX_SIZE_MB) * 0x100000L;
        this.allocator = allocator;
        this.numberOfDirs = ledgerDirsManager.getAllLedgerDirs().size();
        log.info("Started Db Ledger Storage");
        log.info(" - Number of directories: {}", (Object)this.numberOfDirs);
        log.info(" - Write cache size: {} MB", (Object)(writeCacheMaxSize / 0x100000L));
        log.info(" - Read Cache: {} MB", (Object)(readCacheMaxSize / 0x100000L));
        if (readCacheMaxSize + writeCacheMaxSize > PlatformDependent.maxDirectMemory()) {
            throw new IOException("Read and write cache sizes exceed the configured max direct memory size");
        }
        long perDirectoryWriteCacheSize = writeCacheMaxSize / (long)this.numberOfDirs;
        long perDirectoryReadCacheSize = readCacheMaxSize / (long)this.numberOfDirs;
        this.gcExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("GarbageCollector"));
        this.ledgerStorageList = Lists.newArrayList();
        for (File ledgerDir : ledgerDirsManager.getAllLedgerDirs()) {
            File[] dirs = new File[]{ledgerDir.getParentFile()};
            LedgerDirsManager ldm = new LedgerDirsManager(conf, dirs, ledgerDirsManager.getDiskChecker(), statsLogger);
            this.ledgerStorageList.add(this.newSingleDirectoryDbLedgerStorage(conf, ledgerManager, ldm, indexDirsManager, stateManager, checkpointSource, checkpointer, statsLogger, this.gcExecutor, perDirectoryWriteCacheSize, perDirectoryReadCacheSize));
            ldm.getListeners().forEach(ledgerDirsManager::addLedgerDirsListener);
        }
        this.stats = new DbLedgerStorageStats(statsLogger, () -> this.ledgerStorageList.stream().mapToLong(SingleDirectoryDbLedgerStorage::getWriteCacheSize).sum(), () -> this.ledgerStorageList.stream().mapToLong(SingleDirectoryDbLedgerStorage::getWriteCacheCount).sum(), () -> this.ledgerStorageList.stream().mapToLong(SingleDirectoryDbLedgerStorage::getReadCacheSize).sum(), () -> this.ledgerStorageList.stream().mapToLong(SingleDirectoryDbLedgerStorage::getReadCacheCount).sum());
    }

    @VisibleForTesting
    protected SingleDirectoryDbLedgerStorage newSingleDirectoryDbLedgerStorage(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ScheduledExecutorService gcExecutor, long writeCacheSize, long readCacheSize) throws IOException {
        return new SingleDirectoryDbLedgerStorage(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, statsLogger, this.allocator, gcExecutor, writeCacheSize, readCacheSize);
    }

    @Override
    public void start() {
        this.ledgerStorageList.forEach(LedgerStorage::start);
    }

    @Override
    public void shutdown() throws InterruptedException {
        for (LedgerStorage ledgerStorage : this.ledgerStorageList) {
            ledgerStorage.shutdown();
        }
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).ledgerExists(ledgerId);
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).isFenced(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.getLedgerSorage(ledgerId).setMasterKey(ledgerId, masterKey);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.getLedgerSorage(ledgerId).readMasterKey(ledgerId);
    }

    @Override
    public long addEntry(ByteBuf entry) throws IOException, BookieException {
        long ledgerId = entry.getLong(entry.readerIndex());
        return this.getLedgerSorage(ledgerId).addEntry(entry);
    }

    @Override
    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
        return this.getLedgerSorage(ledgerId).getEntry(ledgerId, entryId);
    }

    @Override
    public long getLastAddConfirmed(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).getLastAddConfirmed(ledgerId);
    }

    @Override
    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        return this.getLedgerSorage(ledgerId).waitForLastAddConfirmedUpdate(ledgerId, previousLAC, watcher);
    }

    @Override
    public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.getLedgerSorage(ledgerId).cancelWaitForLastAddConfirmedUpdate(ledgerId, watcher);
    }

    @Override
    public void flush() throws IOException {
        for (LedgerStorage ledgerStorage : this.ledgerStorageList) {
            ledgerStorage.flush();
        }
    }

    @Override
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        for (LedgerStorage ledgerStorage : this.ledgerStorageList) {
            ledgerStorage.checkpoint(checkpoint);
        }
    }

    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        this.getLedgerSorage(ledgerId).deleteLedger(ledgerId);
    }

    @Override
    public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        this.ledgerStorageList.forEach(ls -> ls.registerLedgerDeletionListener(listener));
    }

    @Override
    public void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        this.getLedgerSorage(ledgerId).setExplicitLac(ledgerId, lac);
    }

    @Override
    public ByteBuf getExplicitLac(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).getExplicitLac(ledgerId);
    }

    public long addLedgerToIndex(long ledgerId, boolean isFenced, byte[] masterKey, LedgerCache.PageEntriesIterable pages) throws Exception {
        return this.getLedgerSorage(ledgerId).addLedgerToIndex(ledgerId, isFenced, masterKey, pages);
    }

    public long getLastEntryInLedger(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).getEntryLocationIndex().getLastEntryInLedger(ledgerId);
    }

    public long getLocation(long ledgerId, long entryId) throws IOException {
        return this.getLedgerSorage(ledgerId).getEntryLocationIndex().getLocation(ledgerId, entryId);
    }

    private SingleDirectoryDbLedgerStorage getLedgerSorage(long ledgerId) {
        return this.ledgerStorageList.get(MathUtils.signSafeMod(ledgerId, this.numberOfDirs));
    }

    public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) throws IOException {
        ArrayList<Iterable<Long>> listIt = new ArrayList<Iterable<Long>>(this.numberOfDirs);
        for (SingleDirectoryDbLedgerStorage ls : this.ledgerStorageList) {
            listIt.add(ls.getActiveLedgersInRange(firstLedgerId, lastLedgerId));
        }
        return Iterables.concat(listIt);
    }

    public ByteBuf getLastEntry(long ledgerId) throws IOException {
        return this.getLedgerSorage(ledgerId).getLastEntry(ledgerId);
    }

    @VisibleForTesting
    boolean isFlushRequired() {
        return this.ledgerStorageList.stream().allMatch(SingleDirectoryDbLedgerStorage::isFlushRequired);
    }

    @VisibleForTesting
    List<SingleDirectoryDbLedgerStorage> getLedgerStorageList() {
        return this.ledgerStorageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLedgerIndexEntries(long ledgerId, ServerConfiguration serverConf, SingleDirectoryDbLedgerStorage.LedgerLoggerProcessor processor) throws IOException {
        Preconditions.checkNotNull(serverConf, "ServerConfiguration can't be null");
        Preconditions.checkNotNull(processor, "LedgerLoggger info processor can't null");
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(serverConf, serverConf.getLedgerDirs(), new DiskChecker(serverConf.getDiskUsageThreshold(), serverConf.getDiskUsageWarnThreshold()));
        List<File> ledgerDirs = ledgerDirsManager.getAllLedgerDirs();
        int dirIndex = MathUtils.signSafeMod(ledgerId, ledgerDirs.size());
        String ledgerBasePath = ledgerDirs.get(dirIndex).toString();
        try (EntryLocationIndex entryLocationIndex = new EntryLocationIndex(serverConf, (basePath, subPath, dbConfigType, conf1) -> new KeyValueStorageRocksDB(basePath, subPath, KeyValueStorageFactory.DbConfigType.Small, conf1, true), ledgerBasePath, NullStatsLogger.INSTANCE);){
            long lastEntryId = entryLocationIndex.getLastEntryInLedger(ledgerId);
            for (long currentEntry = 0L; currentEntry <= lastEntryId; ++currentEntry) {
                long offset = entryLocationIndex.getLocation(ledgerId, currentEntry);
                if (offset <= 0L) continue;
                long entryLogId = offset >> 32;
                long position = offset & 0xFFFFFFFFL;
                processor.process(currentEntry, entryLogId, position);
            }
        }
    }

    @Override
    public void forceGC() {
        this.ledgerStorageList.stream().forEach(SingleDirectoryDbLedgerStorage::forceGC);
    }

    @Override
    public boolean isInForceGC() {
        return this.ledgerStorageList.stream().anyMatch(SingleDirectoryDbLedgerStorage::isInForceGC);
    }

    @Override
    public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return this.ledgerStorageList.stream().map(single -> single.getGarbageCollectionStatus().get(0)).collect(Collectors.toList());
    }

    static long getLongVariableOrDefault(ServerConfiguration conf, String keyName, long defaultValue) {
        Object obj = conf.getProperty(keyName);
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj == null) {
            return defaultValue;
        }
        if (StringUtils.isEmpty(conf.getString(keyName))) {
            return defaultValue;
        }
        return conf.getLong(keyName);
    }

    @Override
    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException {
        throw new UnsupportedOperationException("getListOfEntriesOfLedger method is currently unsupported for DbLedgerStorage");
    }
}

