/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.storage.ldb;

import dlshade.com.google.common.collect.Iterables;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.EntryLocation;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.EntryLocationIndexStats;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.LongPairWrapper;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.LongWrapper;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.util.collections.ConcurrentLongHashSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryLocationIndex
implements Closeable {
    private final KeyValueStorage locationsDb;
    private final ConcurrentLongHashSet deletedLedgers = new ConcurrentLongHashSet();
    private final EntryLocationIndexStats stats;
    private static final int DELETE_ENTRIES_BATCH_SIZE = 100000;
    private static final Logger log = LoggerFactory.getLogger(EntryLocationIndex.class);

    public EntryLocationIndex(ServerConfiguration conf, KeyValueStorageFactory storageFactory, String basePath, StatsLogger stats) throws IOException {
        this.locationsDb = storageFactory.newKeyValueStorage(basePath, "locations", KeyValueStorageFactory.DbConfigType.Huge, conf);
        this.stats = new EntryLocationIndexStats(stats, () -> {
            try {
                return this.locationsDb.count();
            }
            catch (IOException e) {
                return -1L;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.locationsDb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLocation(long ledgerId, long entryId) throws IOException {
        LongPairWrapper key = LongPairWrapper.get(ledgerId, entryId);
        LongWrapper value = LongWrapper.get();
        try {
            if (this.locationsDb.get(key.array, value.array) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Entry not found {}@{} in db index", (Object)ledgerId, (Object)entryId);
                }
                long l = 0L;
                return l;
            }
            long l = value.getValue();
            return l;
        }
        finally {
            key.recycle();
            value.recycle();
        }
    }

    public long getLastEntryInLedger(long ledgerId) throws IOException {
        if (this.deletedLedgers.contains(ledgerId)) {
            return -1L;
        }
        return this.getLastEntryInLedgerInternal(ledgerId);
    }

    private long getLastEntryInLedgerInternal(long ledgerId) throws IOException {
        LongPairWrapper maxEntryId = LongPairWrapper.get(ledgerId, Long.MAX_VALUE);
        Map.Entry<byte[], byte[]> entry = this.locationsDb.getFloor(maxEntryId.array);
        maxEntryId.recycle();
        if (entry == null) {
            throw new Bookie.NoEntryException(ledgerId, -1L);
        }
        long foundLedgerId = ArrayUtil.getLong(entry.getKey(), 0);
        long lastEntryId = ArrayUtil.getLong(entry.getKey(), 8);
        if (foundLedgerId == ledgerId) {
            if (log.isDebugEnabled()) {
                log.debug("Found last page in storage db for ledger {} - last entry: {}", (Object)ledgerId, (Object)lastEntryId);
            }
            return lastEntryId;
        }
        throw new Bookie.NoEntryException(ledgerId, -1L);
    }

    public void addLocation(long ledgerId, long entryId, long location) throws IOException {
        KeyValueStorage.Batch batch = this.locationsDb.newBatch();
        this.addLocation(batch, ledgerId, entryId, location);
        batch.flush();
        batch.close();
    }

    public KeyValueStorage.Batch newBatch() {
        return this.locationsDb.newBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocation(KeyValueStorage.Batch batch, long ledgerId, long entryId, long location) throws IOException {
        LongPairWrapper key = LongPairWrapper.get(ledgerId, entryId);
        LongWrapper value = LongWrapper.get(location);
        if (log.isDebugEnabled()) {
            log.debug("Add location - ledger: {} -- entry: {} -- location: {}", new Object[]{ledgerId, entryId, location});
        }
        try {
            batch.put(key.array, value.array);
        }
        finally {
            key.recycle();
            value.recycle();
        }
    }

    public void updateLocations(Iterable<EntryLocation> newLocations) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Update locations -- {}", (Object)Iterables.size(newLocations));
        }
        KeyValueStorage.Batch batch = this.newBatch();
        for (EntryLocation e : newLocations) {
            if (log.isDebugEnabled()) {
                log.debug("Update location - ledger: {} -- entry: {}", (Object)e.ledger, (Object)e.entry);
            }
            this.addLocation(batch, e.ledger, e.entry, e.location);
        }
        batch.flush();
        batch.close();
    }

    public void delete(long ledgerId) throws IOException {
        this.deletedLedgers.add(ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffsetFromDeletedLedgers() throws IOException {
        LongPairWrapper firstKeyWrapper = LongPairWrapper.get(-1L, -1L);
        LongPairWrapper lastKeyWrapper = LongPairWrapper.get(-1L, -1L);
        LongPairWrapper keyToDelete = LongPairWrapper.get(-1L, -1L);
        Set<Long> ledgersToDelete = this.deletedLedgers.items();
        if (ledgersToDelete.isEmpty()) {
            return;
        }
        log.info("Deleting indexes for ledgers: {}", ledgersToDelete);
        long startTime = System.nanoTime();
        long deletedEntries = 0L;
        long deletedEntriesInBatch = 0L;
        KeyValueStorage.Batch batch = this.locationsDb.newBatch();
        byte[] firstDeletedKey = new byte[keyToDelete.array.length];
        try {
            for (long ledgerId : ledgersToDelete) {
                long lastEntryId;
                if (log.isDebugEnabled()) {
                    log.debug("Deleting indexes from ledger {}", (Object)ledgerId);
                }
                firstKeyWrapper.set(ledgerId, 0L);
                lastKeyWrapper.set(ledgerId, Long.MAX_VALUE);
                Map.Entry<byte[], byte[]> firstKeyRes = this.locationsDb.getCeil(firstKeyWrapper.array);
                if (firstKeyRes == null || ArrayUtil.getLong(firstKeyRes.getKey(), 0) != ledgerId) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("No entries found for ledger {}", (Object)ledgerId);
                    continue;
                }
                long firstEntryId = ArrayUtil.getLong(firstKeyRes.getKey(), 8);
                try {
                    lastEntryId = this.getLastEntryInLedgerInternal(ledgerId);
                }
                catch (Bookie.NoEntryException nee) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("No last entry id found for ledger {}", (Object)ledgerId);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Deleting index for ledger {} entries ({} -> {})", new Object[]{ledgerId, firstEntryId, lastEntryId});
                }
                for (long entryId = firstEntryId; entryId <= lastEntryId; ++entryId) {
                    keyToDelete.set(ledgerId, entryId);
                    if (log.isDebugEnabled()) {
                        log.debug("Deleting index for ({}, {})", (Object)keyToDelete.getFirst(), (Object)keyToDelete.getSecond());
                    }
                    batch.remove(keyToDelete.array);
                    ++deletedEntriesInBatch;
                    if (deletedEntries++ != 0L) continue;
                    System.arraycopy(keyToDelete.array, 0, firstDeletedKey, 0, firstDeletedKey.length);
                }
                if (deletedEntriesInBatch <= 100000L) continue;
                batch.flush();
                batch.clear();
                deletedEntriesInBatch = 0L;
            }
        }
        finally {
            try {
                batch.flush();
                batch.clear();
                if (deletedEntries != 0L) {
                    this.locationsDb.compact(firstDeletedKey, keyToDelete.array);
                }
            }
            finally {
                firstKeyWrapper.recycle();
                lastKeyWrapper.recycle();
                keyToDelete.recycle();
                batch.close();
            }
        }
        log.info("Deleted indexes for {} entries from {} ledgers in {} seconds", new Object[]{deletedEntries, ledgersToDelete.size(), (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) / 1000.0});
        for (long ledgerId : ledgersToDelete) {
            this.deletedLedgers.remove(ledgerId);
        }
    }
}

