/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.storage.ldb;

import dlshade.org.apache.bookkeeper.stats.Gauge;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.stats.annotations.StatsDoc;
import java.util.function.Supplier;

@StatsDoc(name="bookie", category="server", help="Entry location index stats")
class EntryLocationIndexStats {
    private static final String ENTRIES_COUNT = "entries-count";
    @StatsDoc(name="entries-count", help="Current number of entries")
    private final Gauge<Long> entriesCountGauge;

    EntryLocationIndexStats(StatsLogger statsLogger, final Supplier<Long> entriesCountSupplier) {
        this.entriesCountGauge = new Gauge<Long>(){

            @Override
            public Long getDefaultValue() {
                return 0L;
            }

            @Override
            public Long getSample() {
                return (Long)entriesCountSupplier.get();
            }
        };
        statsLogger.registerGauge(ENTRIES_COUNT, this.entriesCountGauge);
    }

    public Gauge<Long> getEntriesCountGauge() {
        return this.entriesCountGauge;
    }
}

