/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookieInfoReader;
import dlshade.org.apache.bookkeeper.client.BookiesHealthInfo;
import dlshade.org.apache.bookkeeper.client.DistributionSchedule;
import dlshade.org.apache.bookkeeper.client.api.LedgerMetadata;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import dlshade.org.apache.bookkeeper.common.util.MathUtils;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import dlshade.org.apache.bookkeeper.proto.BookieAddressResolver;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import io.netty.util.HashedWheelTimer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface EnsemblePlacementPolicy {
    public EnsemblePlacementPolicy initialize(ClientConfiguration var1, Optional<DNSToSwitchMapping> var2, HashedWheelTimer var3, FeatureProvider var4, StatsLogger var5, BookieAddressResolver var6);

    public void uninitalize();

    public Set<BookieId> onClusterChanged(Set<BookieId> var1, Set<BookieId> var2);

    public PlacementResult<List<BookieId>> newEnsemble(int var1, int var2, int var3, Map<String, byte[]> var4, Set<BookieId> var5) throws BKException.BKNotEnoughBookiesException;

    public PlacementResult<BookieId> replaceBookie(int var1, int var2, int var3, Map<String, byte[]> var4, List<BookieId> var5, BookieId var6, Set<BookieId> var7) throws BKException.BKNotEnoughBookiesException;

    public void registerSlowBookie(BookieId var1, long var2);

    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> var1, BookiesHealthInfo var2, DistributionSchedule.WriteSet var3);

    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> var1, BookiesHealthInfo var2, DistributionSchedule.WriteSet var3);

    default public void updateBookieInfo(Map<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap) {
    }

    default public int getStickyReadBookieIndex(LedgerMetadata metadata, Optional<Integer> currentStickyBookieIndex) {
        if (!currentStickyBookieIndex.isPresent()) {
            return ThreadLocalRandom.current().nextInt(metadata.getEnsembleSize());
        }
        return MathUtils.signSafeMod(currentStickyBookieIndex.get() + 1, metadata.getEnsembleSize());
    }

    default public PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return PlacementPolicyAdherence.FAIL;
    }

    default public boolean areAckedBookiesAdheringToPlacementPolicy(Set<BookieId> ackedBookies, int writeQuorumSize, int ackQuorumSize) {
        return true;
    }

    public static final class PlacementResult<T> {
        private final T result;
        private final PlacementPolicyAdherence policyAdherence;

        public static <T> PlacementResult<T> of(T result, PlacementPolicyAdherence policyAdherence) {
            return new PlacementResult<T>(result, policyAdherence);
        }

        private PlacementResult(T result, PlacementPolicyAdherence policyAdherence) {
            this.result = result;
            this.policyAdherence = policyAdherence;
        }

        public T getResult() {
            return this.result;
        }

        public PlacementPolicyAdherence isAdheringToPolicy() {
            return this.policyAdherence;
        }
    }

    public static enum PlacementPolicyAdherence {
        FAIL(1),
        MEETS_SOFT(3),
        MEETS_STRICT(5);

        private int numVal;

        private PlacementPolicyAdherence(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }
    }
}

