/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.org.apache.bookkeeper.client.ClientContext;
import dlshade.org.apache.bookkeeper.client.LedgerEntry;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.client.PendingReadOp;
import dlshade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import dlshade.org.apache.bookkeeper.util.MathUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListenerBasedPendingReadOp
extends PendingReadOp {
    private static final Logger log = LoggerFactory.getLogger(ListenerBasedPendingReadOp.class);
    final BookkeeperInternalCallbacks.ReadEntryListener listener;
    final Object ctx;

    ListenerBasedPendingReadOp(LedgerHandle lh, ClientContext clientCtx, long startEntryId, long endEntryId, BookkeeperInternalCallbacks.ReadEntryListener listener, Object ctx, boolean isRecoveryRead) {
        super(lh, clientCtx, startEntryId, endEntryId, isRecoveryRead);
        this.listener = listener;
        this.ctx = ctx;
    }

    @Override
    protected void submitCallback(int code) {
        PendingReadOp.LedgerEntryRequest request;
        while (!this.seq.isEmpty() && (request = (PendingReadOp.LedgerEntryRequest)this.seq.get(0)) != null) {
            LedgerEntry entry;
            if (!request.isComplete()) {
                return;
            }
            this.seq.remove(0);
            long latencyNanos = MathUtils.elapsedNanos(this.requestTimeNanos);
            if (0 == request.getRc()) {
                this.clientCtx.getClientStats().getReadOpLogger().registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
                entry = new LedgerEntry(request.entryImpl);
            } else {
                this.clientCtx.getClientStats().getReadOpLogger().registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
                entry = null;
            }
            request.close();
            this.listener.onEntryComplete(request.getRc(), this.lh, entry, this.ctx);
        }
        this.cancelSpeculativeTask(true);
    }
}

