/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.org.apache.bookkeeper.client.AsyncCallback;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.LedgerEntry;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.client.LedgerHandleAdv;
import dlshade.org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import dlshade.org.apache.bookkeeper.client.impl.LastConfirmedAndEntryImpl;
import java.util.Enumeration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncCallbackUtils {
    private static final Logger log = LoggerFactory.getLogger(SyncCallbackUtils.class);

    SyncCallbackUtils() {
    }

    public static <T> T waitForResult(CompletableFuture<T> future) throws InterruptedException, BKException {
        try {
            try {
                return future.get(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException eignore) {
                return null;
            }
        }
        catch (ExecutionException err) {
            if (err.getCause() instanceof BKException) {
                throw (BKException)err.getCause();
            }
            BKException unexpectedConditionException = BKException.create(-999);
            unexpectedConditionException.initCause(err.getCause());
            throw unexpectedConditionException;
        }
    }

    public static <T> void finish(int rc, T result, CompletableFuture<? super T> future) {
        if (rc != 0) {
            future.completeExceptionally(BKException.create(rc).fillInStackTrace());
        } else {
            future.complete(result);
        }
    }

    static class FutureReadLastConfirmedAndEntry
    extends CompletableFuture<LastConfirmedAndEntry>
    implements AsyncCallback.ReadLastConfirmedAndEntryCallback {
        FutureReadLastConfirmedAndEntry() {
        }

        @Override
        public void readLastConfirmedAndEntryComplete(int rc, long lastConfirmed, LedgerEntry entry, Object ctx) {
            LastConfirmedAndEntryImpl result = LastConfirmedAndEntryImpl.create(lastConfirmed, entry);
            SyncCallbackUtils.finish(rc, result, this);
        }
    }

    static class SyncCloseCallback
    implements AsyncCallback.CloseCallback {
        private final CompletableFuture<Void> future;

        public SyncCloseCallback(CompletableFuture<Void> future) {
            this.future = future;
        }

        @Override
        public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCallbackUtils.finish(rc, null, this.future);
        }
    }

    static class SyncReadLastConfirmedCallback
    implements AsyncCallback.ReadLastConfirmedCallback {
        SyncReadLastConfirmedCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
            LedgerHandle.LastConfirmedCtx lcCtx;
            LedgerHandle.LastConfirmedCtx lastConfirmedCtx = lcCtx = (LedgerHandle.LastConfirmedCtx)ctx;
            synchronized (lastConfirmedCtx) {
                lcCtx.setRC(rc);
                lcCtx.setLastConfirmed(lastConfirmed);
                lcCtx.notify();
            }
        }
    }

    static class FutureReadLastConfirmed
    extends CompletableFuture<Long>
    implements AsyncCallback.ReadLastConfirmedCallback {
        FutureReadLastConfirmed() {
        }

        @Override
        public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
            SyncCallbackUtils.finish(rc, lastConfirmed, this);
        }
    }

    static class SyncAddCallback
    extends CompletableFuture<Long>
    implements AsyncCallback.AddCallback {
        SyncAddCallback() {
        }

        @Override
        public void addComplete(int rc, LedgerHandle lh, long entry, Object ctx) {
            SyncCallbackUtils.finish(rc, entry, this);
        }
    }

    static class SyncReadCallback
    implements AsyncCallback.ReadCallback {
        private final CompletableFuture<Enumeration<LedgerEntry>> future;

        public SyncReadCallback(CompletableFuture<Enumeration<LedgerEntry>> future) {
            this.future = future;
        }

        @Override
        public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
            SyncCallbackUtils.finish(rc, seq, this.future);
        }
    }

    static class LastAddConfirmedCallback
    implements AsyncCallback.AddLacCallback {
        static final LastAddConfirmedCallback INSTANCE = new LastAddConfirmedCallback();

        LastAddConfirmedCallback() {
        }

        @Override
        public void addLacComplete(int rc, LedgerHandle lh, Object ctx) {
            if (rc != 0) {
                log.warn("LastAddConfirmedUpdate failed: {} ", (Object)BKException.getMessage(rc));
            } else if (log.isDebugEnabled()) {
                log.debug("Callback LAC Updated for: {} ", (Object)lh.getId());
            }
        }
    }

    static class SyncDeleteCallback
    implements AsyncCallback.DeleteCallback {
        private final CompletableFuture<Void> future;

        public SyncDeleteCallback(CompletableFuture<Void> future) {
            this.future = future;
        }

        @Override
        public void deleteComplete(int rc, Object ctx) {
            SyncCallbackUtils.finish(rc, null, this.future);
        }
    }

    static class SyncOpenCallback
    implements AsyncCallback.OpenCallback {
        private final CompletableFuture<? super LedgerHandle> future;

        public SyncOpenCallback(CompletableFuture<? super LedgerHandle> future) {
            this.future = future;
        }

        @Override
        public void openComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCallbackUtils.finish(rc, lh, this.future);
        }
    }

    static class SyncCreateAdvCallback
    implements AsyncCallback.CreateCallback {
        private final CompletableFuture<? super LedgerHandleAdv> future;

        public SyncCreateAdvCallback(CompletableFuture<? super LedgerHandleAdv> future) {
            this.future = future;
        }

        @Override
        public void createComplete(int rc, LedgerHandle lh, Object ctx) {
            if (lh == null || lh instanceof LedgerHandleAdv) {
                SyncCallbackUtils.finish(rc, (LedgerHandleAdv)lh, this.future);
            } else {
                SyncCallbackUtils.finish(-999, null, this.future);
            }
        }
    }

    static class SyncCreateCallback
    implements AsyncCallback.CreateCallback {
        private final CompletableFuture<? super LedgerHandle> future;

        public SyncCreateCallback(CompletableFuture<? super LedgerHandle> future) {
            this.future = future;
        }

        @Override
        public void createComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCallbackUtils.finish(rc, lh, this.future);
        }
    }
}

