/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LogExceptionRunnable.class);
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = Preconditions.checkNotNull(task);
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            log.error("Exception while executing runnable " + this.task, t);
            Throwables.throwIfUnchecked(t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        return "LogExceptionRunnable(" + this.task + ")";
    }
}

