/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.common.collections.RecyclableArrayList;
import dlshade.org.apache.bookkeeper.common.util.Recyclable;
import dlshade.org.apache.bookkeeper.common.util.Watcher;
import java.util.function.Function;

public class Watchable<T>
implements Recyclable {
    private final RecyclableArrayList.Recycler<Watcher<T>> recycler;
    private RecyclableArrayList<Watcher<T>> watchers;

    public Watchable(RecyclableArrayList.Recycler<Watcher<T>> recycler) {
        this.recycler = recycler;
        this.watchers = recycler.newInstance();
    }

    synchronized int getNumWatchers() {
        return this.watchers.size();
    }

    public synchronized boolean addWatcher(Watcher<T> w) {
        Preconditions.checkNotNull(w, "Null watcher is provided");
        return this.watchers.add(w);
    }

    public synchronized boolean deleteWatcher(Watcher<T> w) {
        return this.watchers.remove(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> void notifyWatchers(Function<R, T> valueFn, R value) {
        RecyclableArrayList<Watcher<T>> watchersLocal;
        Watchable watchable = this;
        synchronized (watchable) {
            watchersLocal = this.watchers;
            this.watchers = this.recycler.newInstance();
        }
        for (Watcher watcher : watchersLocal) {
            watcher.update(valueFn.apply(value));
        }
        watchersLocal.recycle();
    }

    public synchronized void deleteWatchers() {
        this.watchers.clear();
    }

    @Override
    public synchronized void recycle() {
        this.watchers.recycle();
    }
}

