/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.meta;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.conf.AbstractConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LayoutManager;
import dlshade.org.apache.bookkeeper.meta.LedgerAuditorManager;
import dlshade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import dlshade.org.apache.bookkeeper.meta.LegacyHierarchicalLedgerManager;
import dlshade.org.apache.bookkeeper.meta.ZkLayoutManager;
import dlshade.org.apache.bookkeeper.meta.ZkLedgerAuditorManager;
import dlshade.org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import dlshade.org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import dlshade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import dlshade.org.apache.bookkeeper.replication.ReplicationException;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.util.ZkUtils;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.data.ACL;
import java.io.IOException;
import java.util.List;

public class LegacyHierarchicalLedgerManagerFactory
extends AbstractZkLedgerManagerFactory {
    public static final String NAME = "legacyhierarchical";
    public static final int CUR_VERSION = 1;
    AbstractConfiguration conf;

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager lm, int factoryVersion) throws IOException {
        Preconditions.checkArgument(lm instanceof ZkLayoutManager);
        ZkLayoutManager zkLayoutManager = (ZkLayoutManager)lm;
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.zk = zkLayoutManager.getZk();
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        return new ZkLedgerIdGenerator(this.zk, ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf), "idgen", zkAcls);
    }

    @Override
    public LedgerAuditorManager newLedgerAuditorManager() {
        ServerConfiguration serverConfiguration = new ServerConfiguration(this.conf);
        return new ZkLedgerAuditorManager(this.zk, serverConfiguration, NullStatsLogger.INSTANCE);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new LegacyHierarchicalLedgerManager(this.conf, this.zk);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        return new ZkLedgerUnderreplicationManager(this.conf, this.zk);
    }
}

