/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.meta;

import dlshade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import dlshade.org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import dlshade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import dlshade.org.apache.bookkeeper.util.ZkUtils;
import dlshade.org.apache.commons.lang.StringUtils;
import dlshade.org.apache.zookeeper.AsyncCallback;
import dlshade.org.apache.zookeeper.CreateMode;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.ZooDefs;
import dlshade.org.apache.zookeeper.ZooKeeper;
import dlshade.org.apache.zookeeper.data.ACL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongZkLedgerIdGenerator
implements LedgerIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(LongZkLedgerIdGenerator.class);
    private ZooKeeper zk;
    private String ledgerIdGenPath;
    private ZkLedgerIdGenerator shortIdGen;
    private List<String> highOrderDirectories;
    private HighOrderLedgerIdGenPathStatus ledgerIdGenPathStatus;
    private final List<ACL> zkAcls;

    public LongZkLedgerIdGenerator(ZooKeeper zk, String ledgersPath, String idGenZnodeName, ZkLedgerIdGenerator shortIdGen, List<ACL> zkAcls) {
        this.zk = zk;
        this.ledgerIdGenPath = StringUtils.isBlank(idGenZnodeName) ? ledgersPath : ledgersPath + "/" + idGenZnodeName;
        this.shortIdGen = shortIdGen;
        this.highOrderDirectories = new ArrayList<String>();
        this.ledgerIdGenPathStatus = HighOrderLedgerIdGenPathStatus.UNKNOWN;
        this.zkAcls = zkAcls;
    }

    private void generateLongLedgerIdLowBits(final String ledgerPrefix, final long highBits, final BookkeeperInternalCallbacks.GenericCallback<Long> cb) throws KeeperException, InterruptedException, IOException {
        String highPath = ledgerPrefix + this.formatHalfId((int)highBits);
        ZkLedgerIdGenerator.generateLedgerIdImpl(new BookkeeperInternalCallbacks.GenericCallback<Long>(){

            @Override
            public void operationComplete(int rc, Long result) {
                if (rc == 0) {
                    assert ((highBits & 0xFFFFFFFF00000000L) == 0L);
                    assert ((result & 0xFFFFFFFF00000000L) == 0L);
                    cb.operationComplete(rc, highBits << 32 | result);
                } else if (rc == -106) {
                    try {
                        Long newHighBits = highBits + 1L;
                        LongZkLedgerIdGenerator.this.createHOBPathAndGenerateId(ledgerPrefix, newHighBits.intValue(), cb);
                    }
                    catch (KeeperException e) {
                        LOG.error("Failed to create long ledger ID path", (Throwable)e);
                        cb.operationComplete(-9, null);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.error("Failed to create long ledger ID path", (Throwable)e);
                        cb.operationComplete(-15, null);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to create long ledger ID path", (Throwable)e);
                        cb.operationComplete(-100, null);
                    }
                } else {
                    LOG.error("Failed to create long ledger ID path", (Throwable)KeeperException.create(KeeperException.Code.get(rc)));
                    cb.operationComplete(-9, null);
                }
            }
        }, this.zk, ZkLedgerIdGenerator.createLedgerPrefix(highPath, null), this.zkAcls);
    }

    private String formatHalfId(int i) {
        return String.format("%010d", i);
    }

    private void createHOBPathAndGenerateId(String ledgerPrefix, int hob, BookkeeperInternalCallbacks.GenericCallback<Long> cb) throws KeeperException, InterruptedException, IOException {
        block3: {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating HOB path: {}", (Object)(ledgerPrefix + this.formatHalfId(hob)));
                }
                this.zk.create(ledgerPrefix + this.formatHalfId(hob), new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Tried to create High-order-bits node, but it already existed!", (Throwable)e);
            }
        }
        this.invalidateDirectoryCache();
        this.generateLongLedgerId(cb);
    }

    private void invalidateDirectoryCache() {
        this.highOrderDirectories = null;
    }

    private void generateLongLedgerId(BookkeeperInternalCallbacks.GenericCallback<Long> cb) throws KeeperException, InterruptedException, IOException {
        Optional<Long> largest;
        String hobPrefix = "HOB-";
        String ledgerPrefix = this.ledgerIdGenPath + "/" + "HOB-";
        boolean refreshedDirectories = false;
        if (this.highOrderDirectories == null) {
            refreshedDirectories = true;
            this.highOrderDirectories = this.zk.getChildren(this.ledgerIdGenPath, false);
        }
        if (!(largest = this.highOrderDirectories.stream().map(t -> {
            try {
                return Long.parseLong(t.replace("HOB-", ""));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(t -> t != null).reduce(Math::max)).isPresent()) {
            if (!refreshedDirectories) {
                this.invalidateDirectoryCache();
                this.generateLongLedgerId(cb);
            } else {
                this.createHOBPathAndGenerateId(ledgerPrefix, 1, cb);
            }
            return;
        }
        Long highBits = largest.get();
        this.generateLongLedgerIdLowBits(ledgerPrefix, highBits, cb);
        if (this.highOrderDirectories.size() > 3) {
            Object[] highOrderDirs = this.highOrderDirectories.stream().map(t -> {
                try {
                    return Long.parseLong(t.replace("HOB-", ""));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).filter(t -> t != null).sorted().toArray();
            this.invalidateDirectoryCache();
            for (int i = 0; i < highOrderDirs.length - 3; ++i) {
                String path = ledgerPrefix + this.formatHalfId(((Long)highOrderDirs[i]).intValue());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DELETING HIGH ORDER DIR: {}", (Object)path);
                }
                try {
                    this.zk.delete(path, 0);
                    continue;
                }
                catch (KeeperException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to delete {}", (Object)path);
                }
            }
        }
    }

    private void createLongLedgerIdPathAndGenerateLongLedgerId(final BookkeeperInternalCallbacks.GenericCallback<Long> cb, String createPath) {
        ZkUtils.asyncCreateFullPathOptimistic(this.zk, this.ledgerIdGenPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, String name) {
                try {
                    LongZkLedgerIdGenerator.this.setLedgerIdGenPathStatus(HighOrderLedgerIdGenPathStatus.PRESENT);
                    LongZkLedgerIdGenerator.this.generateLongLedgerId(cb);
                }
                catch (KeeperException e) {
                    LOG.error("Failed to create long ledger ID path", (Throwable)e);
                    LongZkLedgerIdGenerator.this.setLedgerIdGenPathStatus(HighOrderLedgerIdGenPathStatus.UNKNOWN);
                    cb.operationComplete(-9, null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.error("Failed to create long ledger ID path", (Throwable)e);
                    LongZkLedgerIdGenerator.this.setLedgerIdGenPathStatus(HighOrderLedgerIdGenPathStatus.UNKNOWN);
                    cb.operationComplete(-15, null);
                }
                catch (IOException e) {
                    LOG.error("Failed to create long ledger ID path", (Throwable)e);
                    LongZkLedgerIdGenerator.this.setLedgerIdGenPathStatus(HighOrderLedgerIdGenPathStatus.UNKNOWN);
                    cb.operationComplete(-100, null);
                }
            }
        }, null);
    }

    public void invalidateLedgerIdGenPathStatus() {
        this.setLedgerIdGenPathStatus(HighOrderLedgerIdGenPathStatus.UNKNOWN);
    }

    private synchronized void setLedgerIdGenPathStatus(HighOrderLedgerIdGenPathStatus status) {
        this.ledgerIdGenPathStatus = status;
    }

    public synchronized boolean ledgerIdGenPathPresent(ZooKeeper zk) throws KeeperException, InterruptedException {
        switch (this.ledgerIdGenPathStatus) {
            case UNKNOWN: {
                if (zk.exists(this.ledgerIdGenPath, false) != null) {
                    this.ledgerIdGenPathStatus = HighOrderLedgerIdGenPathStatus.PRESENT;
                    return true;
                }
                this.ledgerIdGenPathStatus = HighOrderLedgerIdGenPathStatus.NOT_PRESENT;
                return false;
            }
            case PRESENT: {
                return true;
            }
            case NOT_PRESENT: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void generateLedgerId(final BookkeeperInternalCallbacks.GenericCallback<Long> cb) {
        try {
            if (!this.ledgerIdGenPathPresent(this.zk)) {
                this.shortIdGen.generateLedgerId(new BookkeeperInternalCallbacks.GenericCallback<Long>(){

                    @Override
                    public void operationComplete(int rc, Long result) {
                        if (rc == -106) {
                            LongZkLedgerIdGenerator.this.createLongLedgerIdPathAndGenerateLongLedgerId(cb, LongZkLedgerIdGenerator.this.ledgerIdGenPath);
                        } else {
                            cb.operationComplete(rc, result);
                        }
                    }
                });
            } else {
                this.generateLongLedgerId(cb);
            }
        }
        catch (KeeperException e) {
            LOG.error("Failed to create long ledger ID path", (Throwable)e);
            cb.operationComplete(-9, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Failed to create long ledger ID path", (Throwable)e);
            cb.operationComplete(-15, null);
        }
        catch (IOException e) {
            LOG.error("Failed to create long ledger ID path", (Throwable)e);
            cb.operationComplete(-100, null);
        }
    }

    @Override
    public void close() throws IOException {
        this.shortIdGen.close();
    }

    private static enum HighOrderLedgerIdGenPathStatus {
        UNKNOWN,
        PRESENT,
        NOT_PRESENT;

    }
}

