/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.meta.zk;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.conf.AbstractConfiguration;
import dlshade.org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LayoutManager;
import dlshade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.ZkLayoutManager;
import dlshade.org.apache.bookkeeper.meta.exceptions.Code;
import dlshade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.util.BookKeeperConstants;
import dlshade.org.apache.bookkeeper.util.ZkUtils;
import dlshade.org.apache.bookkeeper.zookeeper.RetryPolicy;
import dlshade.org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import dlshade.org.apache.commons.lang3.StringUtils;
import dlshade.org.apache.zookeeper.CreateMode;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.ZooKeeper;
import dlshade.org.apache.zookeeper.data.ACL;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataDriverBase
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ZKMetadataDriverBase.class);
    protected static final String SCHEME = "zk";
    protected AbstractConfiguration<?> conf;
    protected StatsLogger statsLogger;
    protected List<ACL> acls;
    protected ZooKeeper zk = null;
    protected boolean ownZKHandle = false;
    protected String ledgersRootPath;
    protected LayoutManager layoutManager;
    protected LedgerManagerFactory lmFactory;

    public static String getZKServersFromServiceUri(URI uri) {
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException("Invalid metadata service URI format: " + uri);
        }
        return authority.replace(";", ",");
    }

    public static String resolveZkServers(AbstractConfiguration<?> conf) {
        String metadataServiceUriStr = conf.getMetadataServiceUriUnchecked();
        if (null == metadataServiceUriStr) {
            return conf.getZkServers();
        }
        URI metadataServiceUri = URI.create(metadataServiceUriStr);
        return ZKMetadataDriverBase.getZKServersFromServiceUri(metadataServiceUri);
    }

    public static String resolveZkLedgersRootPath(AbstractConfiguration<?> conf) {
        String metadataServiceUriStr = conf.getMetadataServiceUriUnchecked();
        if (null == metadataServiceUriStr) {
            return conf.getZkLedgersRootPath();
        }
        URI metadataServiceUri = URI.create(metadataServiceUriStr);
        return metadataServiceUri.getPath();
    }

    public static Class<? extends LedgerManagerFactory> resolveLedgerManagerFactory(URI metadataServiceUri) {
        Class ledgerManagerFactoryClass;
        Preconditions.checkNotNull(metadataServiceUri, "Metadata service uri is null");
        String scheme = metadataServiceUri.getScheme();
        Preconditions.checkNotNull(scheme, "Invalid metadata service : " + metadataServiceUri);
        String[] schemeParts = StringUtils.split(scheme.toLowerCase(), '+');
        Preconditions.checkArgument(SCHEME.equals(schemeParts[0]), "Unknown metadata service scheme found : " + schemeParts[0]);
        if (schemeParts.length > 1) {
            switch (schemeParts[1]) {
                case "flat": {
                    ledgerManagerFactoryClass = FlatLedgerManagerFactory.class;
                    break;
                }
                case "hierarchical": {
                    ledgerManagerFactoryClass = HierarchicalLedgerManagerFactory.class;
                    break;
                }
                case "longhierarchical": {
                    ledgerManagerFactoryClass = LongHierarchicalLedgerManagerFactory.class;
                    break;
                }
                case "ms": {
                    ledgerManagerFactoryClass = MSLedgerManagerFactory.class;
                    break;
                }
                case "null": {
                    ledgerManagerFactoryClass = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ledger manager type found '" + schemeParts[1] + "' at uri : " + metadataServiceUri);
                }
            }
        } else {
            ledgerManagerFactoryClass = null;
        }
        return ledgerManagerFactoryClass;
    }

    public String getScheme() {
        return SCHEME;
    }

    protected void initialize(AbstractConfiguration<?> conf, StatsLogger statsLogger, RetryPolicy zkRetryPolicy, Optional<Object> optionalCtx) throws MetadataException {
        this.conf = conf;
        this.acls = ZkUtils.getACLs(conf);
        if (optionalCtx.isPresent() && optionalCtx.get() instanceof ZooKeeper) {
            this.ledgersRootPath = conf.getZkLedgersRootPath();
            log.info("Initialize zookeeper metadata driver with external zookeeper client : ledgersRootPath = {}.", (Object)this.ledgersRootPath);
            this.zk = (ZooKeeper)optionalCtx.get();
            this.ownZKHandle = false;
        } else {
            String zkServers;
            String metadataServiceUriStr;
            try {
                metadataServiceUriStr = conf.getMetadataServiceUri();
            }
            catch (ConfigurationException e) {
                log.error("Failed to retrieve metadata service uri from configuration", (Throwable)e);
                throw new MetadataException(Code.INVALID_METADATA_SERVICE_URI, (Throwable)e);
            }
            URI metadataServiceUri = URI.create(metadataServiceUriStr);
            this.ledgersRootPath = metadataServiceUri.getPath();
            String bookieRegistrationPath = this.ledgersRootPath + "/" + "available";
            String bookieReadonlyRegistrationPath = bookieRegistrationPath + "/" + "readonly";
            try {
                zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri(metadataServiceUri);
            }
            catch (IllegalArgumentException ex) {
                throw new MetadataException(Code.INVALID_METADATA_SERVICE_URI, (Throwable)ex);
            }
            log.info("Initialize zookeeper metadata driver at metadata service uri {} : zkServers = {}, ledgersRootPath = {}.", new Object[]{metadataServiceUriStr, zkServers, this.ledgersRootPath});
            try {
                this.zk = ZooKeeperClient.newBuilder().connectString(zkServers).sessionTimeoutMs(conf.getZkTimeout()).operationRetryPolicy(zkRetryPolicy).requestRateLimit(conf.getZkRequestRateLimit()).statsLogger(statsLogger).build();
                if (null == this.zk.exists(bookieReadonlyRegistrationPath, false)) {
                    try {
                        this.zk.create(bookieReadonlyRegistrationPath, BookKeeperConstants.EMPTY_BYTE_ARRAY, this.acls, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException ex) {
                    }
                    catch (KeeperException.NoNodeException ex) {}
                }
            }
            catch (KeeperException | IOException e) {
                log.error("Failed to create zookeeper client to {}", (Object)zkServers, (Object)e);
                MetadataException me = new MetadataException(Code.METADATA_SERVICE_ERROR, "Failed to create zookeeper client to " + zkServers, e);
                me.fillInStackTrace();
                throw me;
            }
            this.ownZKHandle = true;
        }
        this.layoutManager = new ZkLayoutManager(this.zk, this.ledgersRootPath, this.acls);
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public synchronized LedgerManagerFactory getLedgerManagerFactory() throws MetadataException {
        if (null == this.lmFactory) {
            try {
                this.lmFactory = AbstractZkLedgerManagerFactory.newLedgerManagerFactory(this.conf, this.layoutManager);
            }
            catch (IOException e) {
                throw new MetadataException(Code.METADATA_SERVICE_ERROR, "Failed to initialized ledger manager factory", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
        return this.lmFactory;
    }

    @Override
    public void close() {
        if (null != this.lmFactory) {
            try {
                this.lmFactory.close();
            }
            catch (IOException e) {
                log.warn("Failed to close zookeeper based ledger manager", (Throwable)e);
            }
            this.lmFactory = null;
        }
        if (this.ownZKHandle && null != this.zk) {
            try {
                this.zk.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted on closing zookeeper client", (Throwable)e);
            }
            this.zk = null;
        }
    }

    public ZooKeeper getZk() {
        return this.zk;
    }

    public void setZk(ZooKeeper zk) {
        this.zk = zk;
    }
}

