/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.metastore;

import dlshade.com.google.common.collect.ImmutableSet;
import dlshade.com.google.common.collect.ImmutableSortedMap;
import dlshade.org.apache.bookkeeper.metastore.InMemoryMetastoreTable;
import dlshade.org.apache.bookkeeper.metastore.MSException;
import dlshade.org.apache.bookkeeper.metastore.MetastoreCursor;
import dlshade.org.apache.bookkeeper.metastore.MetastoreTableItem;
import dlshade.org.apache.bookkeeper.metastore.Value;
import dlshade.org.apache.bookkeeper.versioning.Versioned;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;

class InMemoryMetastoreCursor
implements MetastoreCursor {
    private final ScheduledExecutorService scheduler;
    private final Iterator<Map.Entry<String, Versioned<Value>>> iter;
    private final Set<String> fields;

    public InMemoryMetastoreCursor(SortedMap<String, Versioned<Value>> map, Set<String> fields, ScheduledExecutorService scheduler) {
        this.iter = ((ImmutableSet)ImmutableSortedMap.copyOfSorted(map).entrySet()).iterator();
        this.fields = fields;
        this.scheduler = scheduler;
    }

    @Override
    public boolean hasMoreEntries() {
        return this.iter.hasNext();
    }

    @Override
    public Iterator<MetastoreTableItem> readEntries(int numEntries) throws MSException {
        if (numEntries < 0) {
            throw MSException.create(MSException.Code.IllegalOp);
        }
        return this.unsafeReadEntries(numEntries);
    }

    @Override
    public void asyncReadEntries(final int numEntries, final MetastoreCursor.ReadEntriesCallback cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                if (numEntries < 0) {
                    cb.complete(MSException.Code.IllegalOp.getCode(), null, ctx);
                    return;
                }
                Iterator result = InMemoryMetastoreCursor.this.unsafeReadEntries(numEntries);
                cb.complete(MSException.Code.OK.getCode(), result, ctx);
            }
        });
    }

    private Iterator<MetastoreTableItem> unsafeReadEntries(int numEntries) {
        ArrayList<MetastoreTableItem> entries = new ArrayList<MetastoreTableItem>();
        for (int nCount = 0; this.iter.hasNext() && nCount < numEntries; ++nCount) {
            Map.Entry<String, Versioned<Value>> entry = this.iter.next();
            Versioned<Value> value = entry.getValue();
            Versioned<Value> vv = InMemoryMetastoreTable.cloneValue(value.getValue(), value.getVersion(), this.fields);
            String key = entry.getKey();
            entries.add(new MetastoreTableItem(key, vv));
        }
        return entries.iterator();
    }

    @Override
    public void close() throws IOException {
    }
}

