/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto;

import dlshade.org.apache.bookkeeper.proto.BookieProtocol;
import dlshade.org.apache.bookkeeper.proto.BookieRequestProcessor;
import dlshade.org.apache.bookkeeper.proto.ResponseBuilder;
import dlshade.org.apache.bookkeeper.stats.OpStatsLogger;
import dlshade.org.apache.bookkeeper.util.MathUtils;
import dlshade.org.apache.bookkeeper.util.SafeRunnable;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PacketProcessorBase<T extends BookieProtocol.Request>
extends SafeRunnable {
    private static final Logger logger = LoggerFactory.getLogger(PacketProcessorBase.class);
    T request;
    Channel channel;
    BookieRequestProcessor requestProcessor;
    long enqueueNanos;

    PacketProcessorBase() {
    }

    protected void init(T request, Channel channel, BookieRequestProcessor requestProcessor) {
        this.request = request;
        this.channel = channel;
        this.requestProcessor = requestProcessor;
        this.enqueueNanos = MathUtils.nowInNano();
    }

    protected void reset() {
        this.request = null;
        this.channel = null;
        this.requestProcessor = null;
        this.enqueueNanos = -1L;
    }

    protected boolean isVersionCompatible() {
        byte version = ((BookieProtocol.Request)this.request).getProtocolVersion();
        if (version < 0 || version > 2) {
            logger.error("Invalid protocol version, expected something between 0 & 2. got " + ((BookieProtocol.Request)this.request).getProtocolVersion());
            return false;
        }
        return true;
    }

    protected void sendResponse(int rc, Object response, OpStatsLogger statsLogger) {
        this.channel.writeAndFlush(response, this.channel.voidPromise());
        if (0 == rc) {
            statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(this.enqueueNanos), TimeUnit.NANOSECONDS);
        } else {
            statsLogger.registerFailedEvent(MathUtils.elapsedNanos(this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
    }

    protected void sendResponseAndWait(int rc, Object response, OpStatsLogger statsLogger) {
        try {
            this.channel.writeAndFlush(response).await();
        }
        catch (InterruptedException e) {
            return;
        }
        if (0 == rc) {
            statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(this.enqueueNanos), TimeUnit.NANOSECONDS);
        } else {
            statsLogger.registerFailedEvent(MathUtils.elapsedNanos(this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void safeRun() {
        if (!this.isVersionCompatible()) {
            this.sendResponse(103, ResponseBuilder.buildErrorResponse(103, this.request), this.requestProcessor.getRequestStats().getReadRequestStats());
            return;
        }
        this.processPacket();
    }

    protected abstract void processPacket();
}

