/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto.checksum;

import dlshade.com.scurrilous.circe.checksum.Crc32cIntChecksum;
import dlshade.com.scurrilous.circe.crc.Sse42Crc32C;
import dlshade.org.apache.bookkeeper.proto.checksum.DigestManager;
import dlshade.org.apache.commons.lang3.mutable.MutableInt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.FastThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRC32CDigestManager
extends DigestManager {
    private static final Logger log = LoggerFactory.getLogger(CRC32CDigestManager.class);
    private static boolean nonSupportedMessagePrinted = false;
    private static final FastThreadLocal<MutableInt> currentCrc = new FastThreadLocal<MutableInt>(){

        protected MutableInt initialValue() throws Exception {
            return new MutableInt(0);
        }
    };

    public CRC32CDigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
        if (!Sse42Crc32C.isSupported() && !nonSupportedMessagePrinted) {
            log.warn("Sse42Crc32C is not supported, will use a slower CRC32C implementation.");
            nonSupportedMessagePrinted = true;
        }
    }

    @Override
    int getMacCodeLength() {
        return 4;
    }

    @Override
    void populateValueAndReset(ByteBuf buf) {
        MutableInt current = (MutableInt)currentCrc.get();
        buf.writeInt(current.intValue());
        current.setValue(0);
    }

    @Override
    void update(ByteBuf data) {
        MutableInt current = (MutableInt)currentCrc.get();
        int lastCrc = current.intValue();
        current.setValue(Crc32cIntChecksum.resumeChecksum(lastCrc, data));
    }
}

