/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto.checksum;

import dlshade.org.apache.bookkeeper.proto.checksum.DigestManager;
import dlshade.org.apache.bookkeeper.proto.checksum.DirectMemoryCRC32Digest;
import dlshade.org.apache.bookkeeper.proto.checksum.StandardCRC32Digest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.FastThreadLocal;

class CRC32DigestManager
extends DigestManager {
    private static final FastThreadLocal<CRC32Digest> crc = new FastThreadLocal<CRC32Digest>(){

        protected CRC32Digest initialValue() {
            if (DirectMemoryCRC32Digest.isSupported()) {
                return new DirectMemoryCRC32Digest();
            }
            return new StandardCRC32Digest();
        }
    };

    public CRC32DigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
    }

    @Override
    int getMacCodeLength() {
        return 8;
    }

    @Override
    void populateValueAndReset(ByteBuf buf) {
        buf.writeLong(((CRC32Digest)crc.get()).getValueAndReset());
    }

    @Override
    void update(ByteBuf data) {
        ((CRC32Digest)crc.get()).update(data);
    }

    static interface CRC32Digest {
        public long getValueAndReset();

        public void update(ByteBuf var1);
    }
}

