/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto.checksum;

import dlshade.org.apache.bookkeeper.proto.checksum.CRC32DigestManager;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.zip.CRC32;

class DirectMemoryCRC32Digest
implements CRC32DigestManager.CRC32Digest {
    private int crcValue;
    private static final Method updateByteBuffer;
    private static final Method updateBytes;

    DirectMemoryCRC32Digest() {
    }

    public static boolean isSupported() {
        return updateBytes != null;
    }

    @Override
    public long getValueAndReset() {
        long value = (long)this.crcValue & 0xFFFFFFFFL;
        this.crcValue = 0;
        return value;
    }

    @Override
    public void update(ByteBuf buf) {
        int index = buf.readerIndex();
        int length = buf.readableBytes();
        try {
            if (buf.hasMemoryAddress()) {
                this.crcValue = (Integer)updateByteBuffer.invoke(null, this.crcValue, buf.memoryAddress(), index, length);
            } else if (buf.hasArray()) {
                this.crcValue = (Integer)updateBytes.invoke(null, this.crcValue, buf.array(), buf.arrayOffset() + index, length);
            } else {
                byte[] b = new byte[length];
                buf.getBytes(index, b, 0, length);
                this.crcValue = (Integer)updateBytes.invoke(null, this.crcValue, b, 0, b.length);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method updateByteBufferMethod = null;
        Method updateBytesMethod = null;
        try {
            updateByteBufferMethod = CRC32.class.getDeclaredMethod("updateByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
            updateByteBufferMethod.setAccessible(true);
            updateBytesMethod = CRC32.class.getDeclaredMethod("updateBytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
            updateBytesMethod.setAccessible(true);
        }
        catch (Exception e) {
            updateByteBufferMethod = null;
            updateBytesMethod = null;
        }
        updateByteBuffer = updateByteBufferMethod;
        updateBytes = updateBytesMethod;
    }
}

