/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.sasl;

import dlshade.org.apache.bookkeeper.auth.AuthCallbacks;
import dlshade.org.apache.bookkeeper.auth.ClientAuthProvider;
import dlshade.org.apache.bookkeeper.conf.AbstractConfiguration;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.proto.ClientConnectionPeer;
import dlshade.org.apache.bookkeeper.sasl.JAASCredentialsContainer;
import dlshade.org.apache.bookkeeper.sasl.SASLClientAuthProvider;
import dlshade.org.apache.bookkeeper.sasl.SaslClientState;
import dlshade.org.apache.bookkeeper.sasl.SaslConstants;
import dlshade.org.apache.bookkeeper.sasl.TGTRefreshThread;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLClientProviderFactory
implements ClientAuthProvider.Factory,
JAASCredentialsContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SASLClientProviderFactory.class);
    private ClientConfiguration clientConfiguration;
    private LoginContext login;
    private Subject subject;
    private String principal;
    private boolean isKrbTicket;
    private boolean isUsingTicketCache;
    private String loginContextName;
    private TGTRefreshThread ticketRefreshThread;

    @Override
    public void init(ClientConfiguration conf) throws IOException {
        this.clientConfiguration = conf;
        try {
            this.login = this.loginClient();
            this.subject = this.login.getSubject();
            this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
            boolean systemRole = "system".equals(this.clientConfiguration.getClientRole());
            String string = this.loginContextName = systemRole ? this.clientConfiguration.getString("saslJaasAuditorSectionName", "Auditor") : this.clientConfiguration.getString("saslJaasClientSectionName", "BookKeeper");
            if (this.isKrbTicket) {
                this.isUsingTicketCache = SaslConstants.isUsingTicketCache(this.loginContextName);
                this.principal = SaslConstants.getPrincipal(this.loginContextName);
                this.ticketRefreshThread = new TGTRefreshThread(this);
                this.ticketRefreshThread.start();
            }
        }
        catch (LoginException | SaslException error) {
            throw new IOException(error);
        }
    }

    @Override
    public ClientAuthProvider newProvider(ClientConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
        return new SASLClientAuthProvider(addr, completeCb, this.subject);
    }

    @Override
    public String getPluginName() {
        return "sasl";
    }

    private LoginContext loginClient() throws SaslException, LoginException {
        boolean systemRole = "system".equals(this.clientConfiguration.getClientRole());
        String configurationEntry = systemRole ? this.clientConfiguration.getString("saslJaasAuditorSectionName", "Auditor") : this.clientConfiguration.getString("saslJaasClientSectionName", "BookKeeper");
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(configurationEntry);
        if (entries == null) {
            LOG.info("No JAAS Configuration found with section BookKeeper");
            return null;
        }
        try {
            LoginContext loginContext = new LoginContext(configurationEntry, new SaslClientState.ClientCallbackHandler(null));
            loginContext.login();
            return loginContext;
        }
        catch (LoginException error) {
            LOG.error("Error JAAS Configuration subject", (Throwable)error);
            return null;
        }
    }

    @Override
    public void close() {
        block3: {
            if (this.ticketRefreshThread != null) {
                this.ticketRefreshThread.interrupt();
                try {
                    this.ticketRefreshThread.join(10000L);
                }
                catch (InterruptedException exit) {
                    Thread.currentThread().interrupt();
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("interrupted while waiting for TGT reresh thread to stop", (Throwable)exit);
                }
            }
        }
    }

    @Override
    public LoginContext getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(LoginContext login) {
        this.login = login;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public boolean isUsingTicketCache() {
        return this.isUsingTicketCache;
    }

    @Override
    public String getPrincipal() {
        return this.principal;
    }

    @Override
    public AbstractConfiguration getConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    public String getLoginContextName() {
        return this.loginContextName;
    }
}

