/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http;

import dlshade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.HttpServiceProvider;
import dlshade.org.apache.bookkeeper.http.service.ErrorHttpService;
import dlshade.org.apache.bookkeeper.http.service.HeartbeatService;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.proto.BookieServer;
import dlshade.org.apache.bookkeeper.replication.Auditor;
import dlshade.org.apache.bookkeeper.replication.AutoRecoveryMain;
import dlshade.org.apache.bookkeeper.server.http.service.AutoRecoveryStatusService;
import dlshade.org.apache.bookkeeper.server.http.service.BookieInfoService;
import dlshade.org.apache.bookkeeper.server.http.service.BookieIsReadyService;
import dlshade.org.apache.bookkeeper.server.http.service.BookieStateService;
import dlshade.org.apache.bookkeeper.server.http.service.ConfigurationService;
import dlshade.org.apache.bookkeeper.server.http.service.DecommissionService;
import dlshade.org.apache.bookkeeper.server.http.service.DeleteLedgerService;
import dlshade.org.apache.bookkeeper.server.http.service.ExpandStorageService;
import dlshade.org.apache.bookkeeper.server.http.service.GCDetailsService;
import dlshade.org.apache.bookkeeper.server.http.service.GetLastLogMarkService;
import dlshade.org.apache.bookkeeper.server.http.service.GetLedgerMetaService;
import dlshade.org.apache.bookkeeper.server.http.service.ListBookieInfoService;
import dlshade.org.apache.bookkeeper.server.http.service.ListBookiesService;
import dlshade.org.apache.bookkeeper.server.http.service.ListDiskFilesService;
import dlshade.org.apache.bookkeeper.server.http.service.ListLedgerService;
import dlshade.org.apache.bookkeeper.server.http.service.ListUnderReplicatedLedgerService;
import dlshade.org.apache.bookkeeper.server.http.service.LostBookieRecoveryDelayService;
import dlshade.org.apache.bookkeeper.server.http.service.MetricsService;
import dlshade.org.apache.bookkeeper.server.http.service.ReadLedgerEntryService;
import dlshade.org.apache.bookkeeper.server.http.service.RecoveryBookieService;
import dlshade.org.apache.bookkeeper.server.http.service.TriggerAuditService;
import dlshade.org.apache.bookkeeper.server.http.service.TriggerGCService;
import dlshade.org.apache.bookkeeper.server.http.service.WhoIsAuditorService;
import dlshade.org.apache.bookkeeper.stats.StatsProvider;
import dlshade.org.apache.zookeeper.KeeperException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKHttpServiceProvider
implements HttpServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(BKHttpServiceProvider.class);
    private final StatsProvider statsProvider;
    private final BookieServer bookieServer;
    private final AutoRecoveryMain autoRecovery;
    private final ServerConfiguration serverConf;
    private final BookKeeperAdmin bka;
    private final ExecutorService executor;

    private BKHttpServiceProvider(BookieServer bookieServer, AutoRecoveryMain autoRecovery, ServerConfiguration serverConf, StatsProvider statsProvider) throws IOException, KeeperException, InterruptedException, BKException {
        this.bookieServer = bookieServer;
        this.autoRecovery = autoRecovery;
        this.serverConf = serverConf;
        this.statsProvider = statsProvider;
        ClientConfiguration clientConfiguration = new ClientConfiguration(serverConf);
        this.bka = new BookKeeperAdmin(clientConfiguration);
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("BKHttpServiceThread").setDaemon(true).build());
    }

    @Override
    public void close() throws IOException {
        try {
            this.executor.shutdown();
            if (this.bka != null) {
                this.bka.close();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            log.error("Interruption while closing BKHttpServiceProvider", (Throwable)ie);
            throw new IOException("Interruption while closing BKHttpServiceProvider", ie);
        }
        catch (BKException e) {
            log.error("Error while closing BKHttpServiceProvider", (Throwable)e);
            throw new IOException("Error while closing BKHttpServiceProvider", e);
        }
    }

    private ServerConfiguration getServerConf() {
        return this.serverConf;
    }

    private Auditor getAuditor() {
        return this.autoRecovery == null ? null : this.autoRecovery.getAuditor();
    }

    private Bookie getBookie() {
        return this.bookieServer == null ? null : this.bookieServer.getBookie();
    }

    @Override
    public HttpEndpointService provideHttpEndpointService(HttpServer.ApiType type) {
        ServerConfiguration configuration = this.getServerConf();
        if (configuration == null) {
            return new ErrorHttpService();
        }
        switch (type) {
            case HEARTBEAT: {
                return new HeartbeatService();
            }
            case SERVER_CONFIG: {
                return new ConfigurationService(configuration);
            }
            case METRICS: {
                return new MetricsService(configuration, this.statsProvider);
            }
            case DELETE_LEDGER: {
                return new DeleteLedgerService(configuration);
            }
            case LIST_LEDGER: {
                return new ListLedgerService(configuration, this.bookieServer);
            }
            case GET_LEDGER_META: {
                return new GetLedgerMetaService(configuration, this.bookieServer);
            }
            case READ_LEDGER_ENTRY: {
                return new ReadLedgerEntryService(configuration, this.bka);
            }
            case LIST_BOOKIES: {
                return new ListBookiesService(configuration, this.bka);
            }
            case LIST_BOOKIE_INFO: {
                return new ListBookieInfoService(configuration);
            }
            case LAST_LOG_MARK: {
                return new GetLastLogMarkService(configuration);
            }
            case LIST_DISK_FILE: {
                return new ListDiskFilesService(configuration);
            }
            case EXPAND_STORAGE: {
                return new ExpandStorageService(configuration);
            }
            case GC: {
                return new TriggerGCService(configuration, this.bookieServer);
            }
            case GC_DETAILS: {
                return new GCDetailsService(configuration, this.bookieServer);
            }
            case BOOKIE_STATE: {
                return new BookieStateService(this.bookieServer.getBookie());
            }
            case BOOKIE_IS_READY: {
                return new BookieIsReadyService(this.bookieServer.getBookie());
            }
            case BOOKIE_INFO: {
                return new BookieInfoService(this.bookieServer.getBookie());
            }
            case AUTORECOVERY_STATUS: {
                return new AutoRecoveryStatusService(configuration);
            }
            case RECOVERY_BOOKIE: {
                return new RecoveryBookieService(configuration, this.bka, this.executor);
            }
            case LIST_UNDER_REPLICATED_LEDGER: {
                return new ListUnderReplicatedLedgerService(configuration, this.bookieServer);
            }
            case WHO_IS_AUDITOR: {
                return new WhoIsAuditorService(configuration, this.bka);
            }
            case TRIGGER_AUDIT: {
                return new TriggerAuditService(configuration, this.bka);
            }
            case LOST_BOOKIE_RECOVERY_DELAY: {
                return new LostBookieRecoveryDelayService(configuration, this.bka);
            }
            case DECOMMISSION: {
                return new DecommissionService(configuration, this.bka, this.executor);
            }
        }
        return new ConfigurationService(configuration);
    }

    public static class Builder {
        BookieServer bookieServer = null;
        AutoRecoveryMain autoRecovery = null;
        ServerConfiguration serverConf = null;
        StatsProvider statsProvider = null;

        public Builder setBookieServer(BookieServer bookieServer) {
            this.bookieServer = bookieServer;
            return this;
        }

        public Builder setAutoRecovery(AutoRecoveryMain autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        public Builder setServerConfiguration(ServerConfiguration conf) {
            this.serverConf = conf;
            return this;
        }

        public Builder setStatsProvider(StatsProvider statsProvider) {
            this.statsProvider = statsProvider;
            return this;
        }

        public BKHttpServiceProvider build() throws IOException, KeeperException, InterruptedException, BKException {
            return new BKHttpServiceProvider(this.bookieServer, this.autoRecovery, this.serverConf, this.statsProvider);
        }
    }
}

